/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision;

import java.net.InetAddress;
import java.util.Iterator;
import java.util.Set;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;

class DnsRecord {
    private InetAddress m_ip;
    private String m_hostname;
    private String m_zone;

    DnsRecord(OnmsNode node) {
        OnmsIpInterface primaryInterface = node.getPrimaryInterface();
        if (primaryInterface == null) {
            DnsRecord.log().debug("Constructor: no primary interface found for nodeid: " + node.getNodeId());
            Set ipInterfaces = node.getIpInterfaces();
            Iterator i$ = ipInterfaces.iterator();
            if (i$.hasNext()) {
                OnmsIpInterface onmsIpInterface = (OnmsIpInterface)i$.next();
                this.m_ip = onmsIpInterface.getIpAddress();
            }
        } else {
            DnsRecord.log().debug("Constructor: primary interface found for nodeid: " + node.getNodeId());
            this.m_ip = primaryInterface.getIpAddress();
        }
        DnsRecord.log().debug("Constructor: set ip address: " + this.m_ip);
        this.m_hostname = node.getLabel() + ".";
        DnsRecord.log().debug("Constructor: set hostname: " + this.m_hostname);
        this.m_zone = this.m_hostname.substring(this.m_hostname.indexOf(46) + 1);
        DnsRecord.log().debug("Constructor: set zone: " + this.m_zone);
    }

    public InetAddress getIp() {
        return this.m_ip;
    }

    public String getZone() {
        return this.m_zone;
    }

    public String getHostname() {
        return this.m_hostname;
    }

    private static ThreadCategory log() {
        return ThreadCategory.getInstance(DnsRecord.class);
    }
}

