/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.web.response;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.opennms.netmgt.provision.detector.web.request.WebRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebResponse {
    private static final Logger LOG = LoggerFactory.getLogger(WebResponse.class);
    private String expectedRange;
    private String expectedText;
    private HttpResponse httpResponse;

    public WebResponse(WebRequest request, HttpResponse response) {
        if (request != null) {
            this.expectedRange = request.getResponseRange();
            this.expectedText = request.getResponseText();
        }
        this.httpResponse = response;
    }

    public boolean isValid() {
        if (this.httpResponse == null || this.expectedRange == null) {
            return false;
        }
        Integer statusCode = this.httpResponse.getStatusLine().getStatusCode();
        LOG.debug("HTTP response status code: {}", (Object)statusCode);
        boolean retval = this.inRange(this.expectedRange, statusCode);
        if (this.expectedText != null) {
            try {
                String responseText = EntityUtils.toString((HttpEntity)this.httpResponse.getEntity());
                LOG.debug("HTTP response text: {}", (Object)responseText);
                LOG.debug("HTTP checking if output matches {}", (Object)this.expectedText);
                if (this.expectedText.charAt(0) == '~') {
                    Pattern p = Pattern.compile(this.expectedText.substring(1), 8);
                    Matcher m = p.matcher(responseText);
                    retval = m.find();
                } else {
                    retval = responseText.equals(this.expectedText);
                }
            }
            catch (Exception e) {
                LOG.info(e.getMessage(), (Throwable)e);
                retval = false;
            }
        }
        LOG.debug("HTTP detected ? {}", (Object)retval);
        return retval;
    }

    private boolean inRange(String range, Integer val) {
        String[] boundries = range.split("-");
        return val >= Integer.valueOf(boundries[0]) && val <= Integer.valueOf(boundries[1]);
    }
}

