/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.support.ssh;

import java.net.InetAddress;
import java.util.Map;
import org.apache.regexp.RE;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.TimeoutTracker;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.provision.support.ssh.Distributable;
import org.opennms.netmgt.provision.support.ssh.IPv4Monitor;
import org.opennms.netmgt.provision.support.ssh.InsufficientParametersException;
import org.opennms.netmgt.provision.support.ssh.MonitoredService;
import org.opennms.netmgt.provision.support.ssh.NetworkInterface;
import org.opennms.netmgt.provision.support.ssh.NetworkInterfaceNotSupportedException;
import org.opennms.netmgt.provision.support.ssh.Ssh;

@Distributable
public final class SshMonitor
extends IPv4Monitor {
    private static final int DEFAULT_RETRY = 0;
    public static final int DEFAULT_TIMEOUT = 3000;
    public static final int DEFAULT_PORT = 22;

    public PollStatus poll(InetAddress address, Map parameters) {
        TimeoutTracker tracker = new TimeoutTracker(parameters, 0, 3000);
        int port = ParameterMap.getKeyedInteger((Map)parameters, (String)"port", (int)22);
        String banner = ParameterMap.getKeyedString((Map)parameters, (String)"banner", null);
        String match = ParameterMap.getKeyedString((Map)parameters, (String)"match", null);
        String clientBanner = ParameterMap.getKeyedString((Map)parameters, (String)"client-banner", (String)"SSH-1.99-OpenNMS_1.5");
        PollStatus ps = PollStatus.unavailable();
        Ssh ssh = new Ssh(address, port, tracker.getConnectionTimeout());
        ssh.setClientBanner(clientBanner);
        RE regex = null;
        if (match == null && (banner == null || banner.equals("*"))) {
            regex = null;
        } else if (match != null) {
            regex = new RE(match);
        } else if (banner != null) {
            regex = new RE(banner);
        }
        tracker.reset();
        while (tracker.shouldRetry() && !ps.isAvailable()) {
            try {
                ps = ssh.poll(tracker);
            }
            catch (InsufficientParametersException e) {
                this.log().error(e.getMessage());
                break;
            }
            if (ps.isAvailable()) {
                if (regex == null) {
                    return ps;
                }
                String response = ssh.getServerBanner();
                if (response == null) {
                    return PollStatus.unavailable((String)"server closed connection before banner was recieved.");
                }
                if (regex.match(response)) {
                    if (this.log().isDebugEnabled()) {
                        this.log().debug("isServer: matching response=" + response);
                    }
                    return ps;
                }
                if (this.log().isDebugEnabled()) {
                    this.log().debug("isServer: NON-matching response=" + response);
                }
                return PollStatus.unavailable((String)("server responded, but banner did not match '" + banner + "'"));
            }
            tracker.nextAttempt();
        }
        return ps;
    }

    public PollStatus poll(MonitoredService svc, Map parameters) {
        NetworkInterface iface = svc.getNetInterface();
        if (iface.getType() != 1) {
            throw new NetworkInterfaceNotSupportedException("Unsupported interface type, only TYPE_IPV4 currently supported");
        }
        InetAddress address = (InetAddress)iface.getAddress();
        return this.poll(address, parameters);
    }
}

