/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.ssh.client;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Collections;
import org.apache.regexp.RE;
import org.opennms.core.utils.LogUtils;
import org.opennms.core.utils.TimeoutTracker;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.provision.detector.ssh.request.NullRequest;
import org.opennms.netmgt.provision.detector.ssh.response.SshResponse;
import org.opennms.netmgt.provision.support.Client;
import org.opennms.netmgt.provision.support.ssh.InsufficientParametersException;
import org.opennms.netmgt.provision.support.ssh.Ssh;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SshClient
implements Client<NullRequest, SshResponse> {
    private boolean m_isAvailable = false;
    private String m_banner = null;
    private String m_match = null;
    private String m_clientBanner = "SSH-1.99-OpenNMS_1.5";
    public static final int DEFAULT_RETRY = 0;

    public void close() {
    }

    public void connect(InetAddress address, int port, int timeout) throws IOException, Exception {
        TimeoutTracker tracker = new TimeoutTracker(Collections.emptyMap(), 0, timeout);
        String banner = this.m_banner;
        String match = this.m_match;
        String clientBanner = this.m_clientBanner;
        PollStatus ps = PollStatus.unavailable();
        Ssh ssh = new Ssh(address, port, tracker.getConnectionTimeout());
        ssh.setClientBanner(clientBanner);
        RE regex = null;
        if (match == null && (banner == null || banner.equals("*"))) {
            regex = null;
        } else if (match != null) {
            regex = new RE(match);
        } else if (banner != null) {
            regex = new RE(banner);
        }
        tracker.reset();
        while (tracker.shouldRetry() && !ps.isAvailable()) {
            try {
                ps = ssh.poll(tracker);
            }
            catch (InsufficientParametersException e) {
                LogUtils.errorf((Object)this, (String)e.getMessage(), (Object[])new Object[0]);
                break;
            }
            tracker.nextAttempt();
        }
        if (regex != null && ps.isAvailable()) {
            String response = ssh.getServerBanner();
            if (response == null) {
                ps = PollStatus.unavailable((String)"server closed connection before banner was recieved.");
            }
            if (!regex.match(response)) {
                LogUtils.debugf((Object)this, (String)"isServer: NON-matching response='%s'", (Object[])new Object[]{response});
                ps = PollStatus.unavailable((String)("server responded, but banner did not match '" + banner + "'"));
            } else {
                LogUtils.debugf((Object)this, (String)"isServer: matching response='%s'", (Object[])new Object[]{response});
            }
        }
        PollStatus result = ps;
        this.m_isAvailable = result.isAvailable();
    }

    public SshResponse receiveBanner() throws IOException, Exception {
        SshResponse response = new SshResponse();
        response.receive(this.m_isAvailable);
        return response;
    }

    public SshResponse sendRequest(NullRequest request) throws IOException, Exception {
        return null;
    }

    public void setBanner(String banner) {
        this.m_banner = banner;
    }

    public void setMatch(String match) {
        this.m_match = match;
    }

    public void setClientBanner(String clientBanner) {
        this.m_clientBanner = clientBanner;
    }
}

