/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.ssh;

import org.opennms.netmgt.provision.detector.ssh.client.SshClient;
import org.opennms.netmgt.provision.detector.ssh.request.NullRequest;
import org.opennms.netmgt.provision.detector.ssh.response.SshResponse;
import org.opennms.netmgt.provision.support.BasicDetector;
import org.opennms.netmgt.provision.support.Client;
import org.opennms.netmgt.provision.support.ClientConversation;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
@Scope(value="prototype")
public class SshDetector
extends BasicDetector<NullRequest, SshResponse> {
    private static final String DEFAULT_SERVICE_NAME = "SSH";
    private static final int DEFAULT_PORT = 22;
    private String m_banner = null;
    private String m_match = null;
    private String m_clientBanner = "SSH-1.99-OpenNMS_1.5";

    public SshDetector() {
        super(DEFAULT_SERVICE_NAME, 22);
    }

    public SshDetector(String serviceName, int port) {
        super(serviceName, port);
    }

    protected Client<NullRequest, SshResponse> getClient() {
        SshClient client = new SshClient();
        client.setBanner(this.getBanner());
        client.setMatch(this.getMatch());
        client.setClientBanner(this.getClientBanner());
        return client;
    }

    protected void onInit() {
        this.expectBanner(this.sshIsAvailable());
    }

    private ClientConversation.ResponseValidator<SshResponse> sshIsAvailable() {
        return new ClientConversation.ResponseValidator<SshResponse>(){

            public boolean validate(SshResponse response) throws Exception {
                return response.isAvailable();
            }
        };
    }

    public void setBanner(String banner) {
        this.m_banner = banner;
    }

    public String getBanner() {
        return this.m_banner;
    }

    public void setMatch(String match) {
        this.m_match = match;
    }

    public String getMatch() {
        return this.m_match;
    }

    public void setClientBanner(String clientBanner) {
        this.m_clientBanner = clientBanner;
    }

    public String getClientBanner() {
        return this.m_clientBanner;
    }
}

