/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.support.ssh;

import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;
import org.opennms.core.utils.ThreadCategory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterMap {
    public static long getKeyedLong(Map<String, Object> map, String key, long defValue) {
        long value = defValue;
        Object oValue = map.get(key);
        if (oValue != null && oValue instanceof String) {
            try {
                value = Long.parseLong((String)oValue);
            }
            catch (NumberFormatException ne) {
                value = defValue;
                ThreadCategory.getInstance(ParameterMap.class).info((Object)("getLongByKey: Failed to convert value " + oValue + " for key " + key));
            }
            map.put(key, value);
        } else if (oValue != null) {
            value = ((Number)oValue).longValue();
        }
        return value;
    }

    public static int getKeyedInteger(Map<String, Object> map, String key, int defValue) {
        return new Long(ParameterMap.getKeyedLong(map, key, defValue)).intValue();
    }

    public static final int[] getKeyedIntegerArray(Map<String, Object> map, String key, int[] defValues) {
        int[] result = defValues;
        Object oValue = map.get(key);
        if (oValue != null && oValue instanceof int[]) {
            result = (int[])oValue;
        } else if (oValue != null) {
            int x;
            ArrayList<Integer> tmpList = new ArrayList<Integer>(5);
            StringTokenizer ints = new StringTokenizer(oValue.toString(), " ;:,");
            while (ints.hasMoreElements()) {
                try {
                    x = Integer.parseInt(ints.nextToken());
                    tmpList.add(x);
                }
                catch (NumberFormatException e) {
                    ThreadCategory.getInstance(ParameterMap.class).warn((Object)("getKeyedIntegerList: list member for key " + key + " is malformed"), (Throwable)e);
                }
            }
            result = new int[tmpList.size()];
            for (x = 0; x < result.length; ++x) {
                result[x] = (Integer)tmpList.get(x);
            }
            map.put(key, result);
        }
        return result;
    }

    public static String getKeyedString(Map<String, Object> map, String key, String defValue) {
        String value = defValue;
        Object oValue = map.get(key);
        if (oValue != null && oValue instanceof String) {
            value = (String)oValue;
        } else if (oValue != null) {
            value = oValue.toString();
            map.put(key, value);
        }
        return value;
    }

    public static boolean getKeyedBoolean(Map<String, Object> map, String key, boolean defValue) {
        boolean value = defValue;
        Object oValue = map.get(key);
        if (oValue != null && oValue instanceof String) {
            oValue = Boolean.valueOf((String)oValue);
        }
        if (oValue != null && oValue instanceof Boolean) {
            try {
                value = (Boolean)oValue;
            }
            catch (NumberFormatException ne) {
                value = defValue;
                ThreadCategory.getInstance(ParameterMap.class).info((Object)("getBoolByKey: Failed to convert value " + oValue + " for key " + key));
            }
            map.put(key, value);
        } else if (oValue != null) {
            value = (Boolean)oValue;
        }
        return value;
    }
}

