/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.snmp;

import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.util.Map;
import java.util.regex.Pattern;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.provision.detector.snmp.SnmpDetector;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class DiskUsageDetector
extends SnmpDetector {
    private static final Logger LOG = LoggerFactory.getLogger(DiskUsageDetector.class);
    private static final String PROTOCOL_NAME = "DiskUsage";
    private static final String DEFAULT_OID = ".1.3.6.1.2.1.1.2.0";
    private static final String hrStorageDescr = ".1.3.6.1.2.1.25.2.3.1.3";
    private static final int MATCH_TYPE_EXACT = 0;
    private static final int MATCH_TYPE_STARTSWITH = 1;
    private static final int MATCH_TYPE_ENDSWITH = 2;
    private static final int MATCH_TYPE_REGEX = 3;
    private String m_matchType = "";
    private String m_disk;
    private String m_hrStorageDescr;

    public DiskUsageDetector() {
        this.setServiceName(PROTOCOL_NAME);
        this.setOid(DEFAULT_OID);
        this.setHrStorageDescr(hrStorageDescr);
    }

    public String getProtocolName() {
        return PROTOCOL_NAME;
    }

    public boolean isProtocolSupported(InetAddress address) {
        try {
            SnmpAgentConfig agentConfig = SnmpPeerFactory.getInstance().getAgentConfig(address);
            return this.getValue(agentConfig, DEFAULT_OID) != null;
        }
        catch (Throwable t) {
            throw new UndeclaredThrowableException(t);
        }
    }

    @Override
    public boolean isServiceDetected(InetAddress address) {
        int matchType = 0;
        try {
            SnmpObjId hrStorageDescrSnmpObject;
            Map descrResults;
            SnmpAgentConfig agentConfig = this.getAgentConfigFactory().getAgentConfig(address);
            if (this.getPort() > 0) {
                agentConfig.setPort(this.getPort());
            }
            if (this.getTimeout() > 0) {
                agentConfig.setTimeout(this.getTimeout());
            }
            if (this.getRetries() > -1) {
                agentConfig.setRetries(this.getRetries());
            }
            if (this.getForceVersion() != null) {
                String version = this.getForceVersion();
                if (version.equalsIgnoreCase("snmpv1")) {
                    agentConfig.setVersion(1);
                } else if (version.equalsIgnoreCase("snmpv2") || version.equalsIgnoreCase("snmpv2c")) {
                    agentConfig.setVersion(2);
                } else if (version.equalsIgnoreCase("snmpv3")) {
                    agentConfig.setVersion(3);
                }
            }
            if (!"".equals(this.getMatchType())) {
                String matchTypeStr = this.getMatchType();
                if (matchTypeStr.equalsIgnoreCase("exact")) {
                    matchType = 0;
                } else if (matchTypeStr.equalsIgnoreCase("startswith")) {
                    matchType = 1;
                } else if (matchTypeStr.equalsIgnoreCase("endswith")) {
                    matchType = 2;
                } else if (matchTypeStr.equalsIgnoreCase("regex")) {
                    matchType = 3;
                } else {
                    throw new RuntimeException("Unknown value '" + matchTypeStr + "' for parameter 'match-type'");
                }
            }
            if ((descrResults = SnmpUtils.getOidValues((SnmpAgentConfig)agentConfig, (String)"DiskUsagePoller", (SnmpObjId)(hrStorageDescrSnmpObject = SnmpObjId.get((String)this.getHrStorageDescr())))).size() == 0) {
                return false;
            }
            for (Map.Entry e : descrResults.entrySet()) {
                LOG.debug("capsd: SNMPwalk succeeded, addr={} oid={} instance={} value={}", new Object[]{InetAddressUtils.str((InetAddress)address), hrStorageDescrSnmpObject, e.getKey(), e.getValue()});
                if (!this.isMatch(((SnmpValue)e.getValue()).toString(), this.getDisk(), matchType)) continue;
                LOG.debug("Found disk '{}' (matching hrStorageDescr was '{}')", (Object)this.getDisk(), e.getValue());
                return true;
            }
            return false;
        }
        catch (Throwable t) {
            throw new UndeclaredThrowableException(t);
        }
    }

    private boolean isMatch(String candidate, String target, int matchType) {
        boolean matches = false;
        LOG.debug("isMessage: candidate is '{}', matching against target '{}'", (Object)candidate, (Object)target);
        if (matchType == 0) {
            LOG.debug("Attempting equality match: candidate '{}', target '{}'", (Object)candidate, (Object)target);
            matches = candidate.equals(target);
        } else if (matchType == 1) {
            LOG.debug("Attempting startsWith match: candidate '{}', target '{}'", (Object)candidate, (Object)target);
            matches = candidate.startsWith(target);
        } else if (matchType == 2) {
            LOG.debug("Attempting endsWith match: candidate '{}', target '{}'", (Object)candidate, (Object)target);
            matches = candidate.endsWith(target);
        } else if (matchType == 3) {
            LOG.debug("Attempting endsWith match: candidate '{}', target '{}'", (Object)candidate, (Object)target);
            matches = Pattern.compile(target).matcher(candidate).find();
        }
        LOG.debug("isMatch: Match is positive");
        return matches;
    }

    public void setMatchType(String matchType) {
        this.m_matchType = matchType;
    }

    public String getMatchType() {
        return this.m_matchType;
    }

    public void setDisk(String disk) {
        this.m_disk = disk;
    }

    public String getDisk() {
        return this.m_disk;
    }

    public void setHrStorageDescr(String hrStorageDescr) {
        this.m_hrStorageDescr = hrStorageDescr;
    }

    public String getHrStorageDescr() {
        return this.m_hrStorageDescr;
    }
}

