/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.snmp;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.util.regex.Pattern;
import org.opennms.netmgt.dao.SnmpAgentConfigFactory;
import org.opennms.netmgt.provision.DetectorMonitor;
import org.opennms.netmgt.provision.exchange.Exchange;
import org.opennms.netmgt.provision.support.AbstractDetector;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpValue;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class SnmpDetector
extends AbstractDetector {
    protected static final String DEFAULT_SERVICE_NAME = "SNMP";
    private static final String DEFAULT_OID = ".1.3.6.1.2.1.1.2.0";
    private static final int DEFAULT_PORT = -1;
    private static final int DEFAULT_TIMEOUT = -1;
    private static final int DEFAULT_RETRIES = -1;
    private String m_oid = ".1.3.6.1.2.1.1.2.0";
    private String m_forceVersion;
    private String m_vbvalue;
    private SnmpAgentConfigFactory m_agentConfigFactory;

    public SnmpDetector() {
        super(DEFAULT_SERVICE_NAME, -1, -1, -1);
    }

    public SnmpDetector(String serviceName, int port) {
        super(serviceName, port, -1, -1);
    }

    public void init() {
    }

    public boolean isServiceDetected(InetAddress address, DetectorMonitor detectMonitor) {
        try {
            String retrievedValue;
            SnmpAgentConfig agentConfig = this.getAgentConfigFactory().getAgentConfig(address);
            String expectedValue = null;
            this.configureAgentPTR(agentConfig);
            this.configureAgentVersion(agentConfig);
            if (this.getVbvalue() != null) {
                expectedValue = this.getVbvalue();
            }
            if ((retrievedValue = this.getValue(agentConfig, this.getOid())) != null && expectedValue != null) {
                return Pattern.compile(expectedValue).matcher(retrievedValue).matches();
            }
            return retrievedValue != null;
        }
        catch (Throwable t) {
            throw new UndeclaredThrowableException(t);
        }
    }

    protected void configureAgentVersion(SnmpAgentConfig agentConfig) {
        if (this.getForceVersion() != null) {
            String version = this.getForceVersion();
            if (version.equalsIgnoreCase("snmpv1")) {
                agentConfig.setVersion(1);
            } else if (version.equalsIgnoreCase("snmpv2") || version.equalsIgnoreCase("snmpv2c")) {
                agentConfig.setVersion(2);
            } else if (version.equalsIgnoreCase("snmpv3")) {
                agentConfig.setVersion(3);
            }
        }
    }

    protected void configureAgentPTR(SnmpAgentConfig agentConfig) {
        if (this.getPort() > 0) {
            agentConfig.setPort(this.getPort());
        }
        if (this.getTimeout() > 0) {
            agentConfig.setTimeout(this.getTimeout());
        }
        if (this.getRetries() > -1) {
            agentConfig.setRetries(this.getRetries());
        }
    }

    protected String getValue(SnmpAgentConfig agentConfig, String oid) {
        SnmpValue val = SnmpUtils.get((SnmpAgentConfig)agentConfig, (SnmpObjId)SnmpObjId.get((String)oid));
        if (val == null || val.isNull() || val.isEndOfMib() || val.isError()) {
            return null;
        }
        return val.toString();
    }

    public void setOid(String oid) {
        this.m_oid = oid;
    }

    public String getOid() {
        return this.m_oid;
    }

    public void setForceVersion(String forceVersion) {
        this.m_forceVersion = forceVersion;
    }

    public String getForceVersion() {
        return this.m_forceVersion;
    }

    public void setVbvalue(String vbvalue) {
        this.m_vbvalue = vbvalue;
    }

    public String getVbvalue() {
        return this.m_vbvalue;
    }

    @Autowired
    public void setAgentConfigFactory(SnmpAgentConfigFactory agentConfigFactory) {
        this.m_agentConfigFactory = agentConfigFactory;
    }

    public SnmpAgentConfigFactory getAgentConfigFactory() {
        return this.m_agentConfigFactory;
    }

    protected void onInit() {
    }

    public void dispose() {
    }

    public static class SnmpExchange
    implements Exchange {
        public boolean matchResponseByString(String input) {
            return false;
        }

        public boolean processResponse(BufferedReader in) throws IOException {
            return false;
        }

        public boolean sendRequest(OutputStream out) throws IOException {
            return false;
        }
    }
}

