/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.loop;

import org.opennms.netmgt.provision.detector.loop.client.LoopClient;
import org.opennms.netmgt.provision.detector.loop.response.LoopResponse;
import org.opennms.netmgt.provision.detector.simple.request.LineOrientedRequest;
import org.opennms.netmgt.provision.support.BasicDetector;
import org.opennms.netmgt.provision.support.Client;
import org.opennms.netmgt.provision.support.ClientConversation;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
@Scope(value="prototype")
public class LoopDetector
extends BasicDetector<LineOrientedRequest, LoopResponse> {
    private static final String DEFAULT_SERVICE_NAME = "LOOP";
    private static final int DEFAULT_PORT = 0;
    private String m_ipMatch;
    private boolean m_isSupported = true;

    public LoopDetector() {
        super(DEFAULT_SERVICE_NAME, 0);
    }

    protected Client<LineOrientedRequest, LoopResponse> getClient() {
        LoopClient loopClient = new LoopClient();
        loopClient.setSupported(this.isSupported());
        return loopClient;
    }

    protected void onInit() {
        this.expectBanner(this.ipMatches(this.getIpMatch()));
    }

    private ClientConversation.ResponseValidator<LoopResponse> ipMatches(final String ipAddr) {
        return new ClientConversation.ResponseValidator<LoopResponse>(){

            public boolean validate(LoopResponse response) throws Exception {
                return response.validateIPMatch(ipAddr);
            }
        };
    }

    public void setIpMatch(String ipMatch) {
        this.m_ipMatch = ipMatch;
    }

    public String getIpMatch() {
        return this.m_ipMatch;
    }

    public void setSupported(boolean isSupported) {
        this.m_isSupported = isSupported;
    }

    public boolean isSupported() {
        return this.m_isSupported;
    }
}

