/*
 * This file is part of the OpenNMS(R) Application.
 *
 * OpenNMS(R) is Copyright (C) 2008 The OpenNMS Group, Inc.  All rights reserved.
 * OpenNMS(R) is a derivative work, containing both original code, included code and modified
 * code that was published under the GNU General Public License. Copyrights for modified
 * and included code are below.
 *
 * OpenNMS(R) is a registered trademark of The OpenNMS Group, Inc.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * For more information contact:
 * OpenNMS Licensing       <license@opennms.org>
 *     http://www.opennms.org/
 *     http://www.opennms.com/
 */
package org.opennms.netmgt.provision.detector.smb.response;

import jcifs.netbios.NbtAddress;

/**
 * <p>NbtAddressResponse class.</p>
 *
 * @author thedesloge
 * @version $Id: $
 */
public class NbtAddressResponse {
    
    private String m_address;
    private NbtAddress m_nbtAddress;
    
    /**
     * <p>receive</p>
     *
     * @param address a {@link java.lang.String} object.
     * @param nbtAddress a {@link jcifs.netbios.NbtAddress} object.
     */
    public void receive(String address, NbtAddress nbtAddress) {
        m_address = address;
        m_nbtAddress = nbtAddress;
    }
    
    /**
     * <p>validateAddressIsNotSame</p>
     *
     * @return a boolean.
     */
    public boolean validateAddressIsNotSame() {
        if(m_nbtAddress.getHostName().equals(m_address)) {
           return false; 
        }else {
            return true;
        }
    }
}
