/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.snmp;

import org.opennms.netmgt.provision.detector.snmp.SnmpDetector;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class Win32ServiceDetector
extends SnmpDetector {
    private static final String SV_SVC_OPERATING_STATE_OID = ".1.3.6.1.4.1.77.1.2.3.1.3";
    private static final String DEFAULT_SERVICE_NAME = "Win32Service";
    private String m_win32SvcName;

    public Win32ServiceDetector() {
        this.setServiceName(DEFAULT_SERVICE_NAME);
        this.setVbvalue("1");
    }

    public String getWin32ServiceName() {
        return this.m_win32SvcName;
    }

    public void setWin32ServiceName(String serviceName) {
        this.m_win32SvcName = serviceName;
        this.log().debug("setWin32ServiceName: setting service name to " + serviceName);
        int snLength = serviceName.length();
        StringBuffer serviceOidBuf = new StringBuffer(SV_SVC_OPERATING_STATE_OID);
        serviceOidBuf.append(".").append(Integer.toString(snLength));
        for (byte thisByte : serviceName.getBytes()) {
            serviceOidBuf.append(".").append(Byte.toString(thisByte));
        }
        this.log().debug("setWin32ServiceName: the OID for the Win32 service  is " + serviceOidBuf.toString());
        this.setOid(serviceOidBuf.toString());
    }
}

