/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.snmp;

import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import org.opennms.netmgt.provision.detector.snmp.SnmpDetector;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class OpenManageChassisDetector
extends SnmpDetector {
    private static final String PROTOCOL_NAME = "Dell_OpenManageChassis";
    private static final String CHASSIS_STATUS_OID = ".1.3.6.1.4.1.674.10892.1.200.10.1.4.1";

    public OpenManageChassisDetector() {
        this.setServiceName(PROTOCOL_NAME);
    }

    @Override
    public boolean isServiceDetected(InetAddress address) {
        try {
            SnmpAgentConfig agentConfig = this.getAgentConfigFactory().getAgentConfig(address);
            this.configureAgentPTR(agentConfig);
            this.configureAgentVersion(agentConfig);
            String chassisStatus = this.getValue(agentConfig, CHASSIS_STATUS_OID);
            if (chassisStatus == null) {
                this.log().warn("isServiceDetected: Cannot receive chassis status");
                return false;
            }
            this.log().debug("isServiceDetected: OpenManageChassis: " + chassisStatus);
            if (Integer.parseInt(chassisStatus.toString()) >= DELL_STATUS.OTHER.value() && Integer.parseInt(chassisStatus.toString()) <= DELL_STATUS.NON_RECOVERABLE.value()) {
                if (this.log().isDebugEnabled()) {
                    this.log().debug("isServiceDetected: OpenManageChassis: is valid, protocol supported.");
                }
                return true;
            }
        }
        catch (Throwable t) {
            throw new UndeclaredThrowableException(t);
        }
        return false;
    }

    private static enum DELL_STATUS {
        OTHER(1),
        UNKNOWN(2),
        OK(3),
        NON_CRITICAL(4),
        CRITICAL(5),
        NON_RECOVERABLE(6);

        private final int state;

        private DELL_STATUS(int s) {
            this.state = s;
        }

        private int value() {
            return this.state;
        }
    }
}

