/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.sms;

import org.opennms.netmgt.provision.detector.simple.request.LineOrientedRequest;
import org.opennms.netmgt.provision.detector.sms.client.SmsClient;
import org.opennms.netmgt.provision.detector.sms.response.SmsResponse;
import org.opennms.netmgt.provision.support.BasicDetector;
import org.opennms.netmgt.provision.support.Client;
import org.opennms.netmgt.provision.support.ResponseValidator;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class SmsDetector
extends BasicDetector<LineOrientedRequest, SmsResponse> {
    private static final String DEFAULT_SERVICE_NAME = "SMS";
    private static final int DEFAULT_PORT = 0;
    private String m_ipMatch;
    private boolean m_isSupported = true;

    public SmsDetector() {
        super(DEFAULT_SERVICE_NAME, 0);
    }

    protected Client<LineOrientedRequest, SmsResponse> getClient() {
        SmsClient loopClient = new SmsClient();
        loopClient.setSupported(this.isSupported());
        return loopClient;
    }

    protected void onInit() {
        this.expectBanner(SmsDetector.ipMatches(this.getIpMatch()));
    }

    private static ResponseValidator<SmsResponse> ipMatches(final String ipAddr) {
        return new ResponseValidator<SmsResponse>(){

            public boolean validate(SmsResponse response) {
                return response.isSms(ipAddr);
            }
        };
    }

    public void setIpMatch(String ipMatch) {
        this.m_ipMatch = ipMatch;
    }

    public String getIpMatch() {
        return this.m_ipMatch;
    }

    public void setSupported(boolean isSupported) {
        this.m_isSupported = isSupported;
    }

    public boolean isSupported() {
        return this.m_isSupported;
    }
}

