/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.snmp;

import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import org.opennms.netmgt.provision.detector.snmp.SnmpDetector;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpValue;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class PercDetector
extends SnmpDetector {
    private static final String PROTOCOL_NAME = "PERC";
    private static final String LOGICAL_BASE_OID = ".1.3.6.1.4.1.3582.1.1.2.1.3";
    private String m_arrayNumber = "0.0";

    public PercDetector() {
        this.setServiceName(PROTOCOL_NAME);
    }

    @Override
    public boolean isServiceDetected(InetAddress address) {
        try {
            SnmpAgentConfig agentConfig = this.getAgentConfigFactory().getAgentConfig(address);
            this.configureAgentPTR(agentConfig);
            this.configureAgentVersion(agentConfig);
            SnmpObjId snmpObjectId = SnmpObjId.get((String)(".1.3.6.1.4.1.3582.1.1.2.1.3." + this.m_arrayNumber));
            SnmpValue value = SnmpUtils.get((SnmpAgentConfig)agentConfig, (SnmpObjId)snmpObjectId);
            if (value.toInt() != 2) {
                this.log().debug("PercMonitor.poll: Bad Disk Found. Log vol(" + this.m_arrayNumber + ") degraded");
                return false;
            }
        }
        catch (Throwable t) {
            throw new UndeclaredThrowableException(t);
        }
        return true;
    }

    public String getArrayNumber() {
        return this.m_arrayNumber;
    }

    public void setArrayNumber(String arrayNumber) {
        this.m_arrayNumber = arrayNumber;
    }
}

