/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.icmp;

import java.net.InetAddress;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.icmp.PingerFactory;
import org.opennms.netmgt.provision.support.SyncAbstractDetector;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class IcmpDetector
extends SyncAbstractDetector {
    public IcmpDetector() {
        super("ICMP", -1);
        this.init();
    }

    public boolean isServiceDetected(InetAddress address) {
        LogUtils.debugf((Object)((Object)this), (String)"isServiceDetected: Testing ICMP based service for address: %s...", (Object[])new Object[]{address});
        boolean found = false;
        try {
            for (int i = 0; i < this.getRetries() && !found; ++i) {
                Number retval = PingerFactory.getInstance().ping(address, (long)this.getTimeout(), this.getRetries());
                LogUtils.debugf((Object)((Object)this), (String)"isServiceDetected: Response time for address: %s is: %d.", (Object[])new Object[]{address, retval});
                if (retval == null) continue;
                found = true;
            }
            LogUtils.infof((Object)((Object)this), (String)"isServiceDetected: ICMP based service for address: %s is detected: %s.", (Object[])new Object[]{address, found});
        }
        catch (InterruptedException e) {
            LogUtils.infof((Object)((Object)this), (String)"isServiceDetected: ICMP based service for address: %s is detected: %s. Received an InterruptedException.", (Object[])new Object[]{address, false});
            Thread.currentThread().interrupt();
        }
        catch (Throwable e) {
            LogUtils.infof((Object)((Object)this), (String)"isServiceDetected: ICMP based service for address: %s is detected: %s. Received an Exception %s.", (Object[])new Object[]{address, false, e});
        }
        return found;
    }

    protected void onInit() {
        this.setTimeout(800);
        this.setRetries(2);
    }

    public void dispose() {
    }
}

