/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.radius;

import net.sourceforge.jradiusclient.RadiusAttribute;
import net.sourceforge.jradiusclient.RadiusPacket;
import net.sourceforge.jradiusclient.util.ChapUtil;
import org.opennms.netmgt.provision.detector.radius.client.RadiusDetectorClient;
import org.opennms.netmgt.provision.support.BasicDetector;
import org.opennms.netmgt.provision.support.Client;
import org.opennms.netmgt.provision.support.ClientConversation;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
@Scope(value="prototype")
public class RadiusAuthDetector
extends BasicDetector<RadiusPacket, RadiusPacket> {
    private static final String DEFAULT_SERVICE_NAME = "RadiusAuth";
    public static final int DEFAULT_AUTH_PORT = 1812;
    public static final int DEFAULT_ACCT_PORT = 1813;
    public static final String DEFAULT_AUTH_TYPE = "pap";
    public static final String DEFAULT_USER = "OpenNMS";
    public static final String DEFAULT_PASSWORD = "OpenNMS";
    public static final String DEFAULT_SECRET = "secret";
    public static final String DEFAULT_NAS_ID = "opennms";
    private int m_authport = 1812;
    private int m_acctport = 1813;
    private String m_secret = "secret";
    private String m_authType = "pap";
    private String m_nasid = "opennms";
    private String m_user = "OpenNMS";
    private String m_password = "OpenNMS";

    protected RadiusAuthDetector() {
        super(DEFAULT_SERVICE_NAME, 1812);
    }

    protected RadiusAuthDetector(String serviceName, int port) {
        super(serviceName, port);
    }

    public void onInit() {
        this.send(this.request(this.getNasID(), this.getUser(), this.getPassword()), this.expectValidResponse(2, 11, 3));
    }

    private ClientConversation.ResponseValidator<RadiusPacket> expectValidResponse(final int accept, final int challenge, final int reject) {
        return new ClientConversation.ResponseValidator<RadiusPacket>(){

            public boolean validate(RadiusPacket response) {
                return response.getPacketType() == accept || response.getPacketType() == challenge || response.getPacketType() == reject;
            }
        };
    }

    private ClientConversation.RequestBuilder<RadiusPacket> request(final String nasID, final String user, final String password) {
        return new ClientConversation.RequestBuilder<RadiusPacket>(){

            public RadiusPacket getRequest() throws Exception {
                ChapUtil chapUtil = new ChapUtil();
                RadiusPacket accessRequest = new RadiusPacket(1);
                RadiusAttribute nasIdAttribute = new RadiusAttribute(32, nasID.getBytes());
                RadiusAttribute userNameAttribute = new RadiusAttribute(1, user.getBytes());
                accessRequest.setAttribute(userNameAttribute);
                accessRequest.setAttribute(nasIdAttribute);
                if (RadiusAuthDetector.this.getAuthType().equalsIgnoreCase("chap")) {
                    byte[] chapChallenge = chapUtil.getNextChapChallenge(16);
                    accessRequest.setAttribute(new RadiusAttribute(3, RadiusAuthDetector.chapEncrypt(password, chapChallenge, chapUtil)));
                    accessRequest.setAttribute(new RadiusAttribute(60, chapChallenge));
                } else {
                    accessRequest.setAttribute(new RadiusAttribute(2, password.getBytes()));
                }
                return accessRequest;
            }
        };
    }

    protected Client<RadiusPacket, RadiusPacket> getClient() {
        RadiusDetectorClient rdc = new RadiusDetectorClient();
        rdc.setAuthport(this.getAuthPort());
        rdc.setAcctPort(this.getAcctPort());
        rdc.setSecret(this.getSecret());
        return rdc;
    }

    private static byte[] chapEncrypt(String plainText, byte[] chapChallenge, ChapUtil chapUtil) {
        byte chapIdentifier = chapUtil.getNextChapIdentifier();
        byte[] chapPassword = new byte[17];
        chapPassword[0] = chapIdentifier;
        System.arraycopy(ChapUtil.chapEncrypt((byte)chapIdentifier, (byte[])plainText.getBytes(), (byte[])chapChallenge), 0, chapPassword, 1, 16);
        return chapPassword;
    }

    public void setAuthPort(int authport) {
        this.m_authport = authport;
    }

    public int getAuthPort() {
        return this.m_authport;
    }

    public void setAcctPort(int acctport) {
        this.m_acctport = acctport;
    }

    public int getAcctPort() {
        return this.m_acctport;
    }

    public void setSecret(String secret) {
        this.m_secret = secret;
    }

    public String getSecret() {
        return this.m_secret;
    }

    public void setAuthType(String authType) {
        this.m_authType = authType;
    }

    public String getAuthType() {
        return this.m_authType;
    }

    public void setNasID(String nasid) {
        this.m_nasid = nasid;
    }

    public String getNasID() {
        return this.m_nasid;
    }

    public void setUser(String user) {
        this.m_user = user;
    }

    public String getUser() {
        return this.m_user;
    }

    public void setPassword(String password) {
        this.m_password = password;
    }

    public String getPassword() {
        return this.m_password;
    }
}

