/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.simple.client;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.SecureRandom;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.provision.detector.simple.client.MultilineOrientedClient;
import org.opennms.netmgt.provision.detector.simple.request.LineOrientedRequest;
import org.opennms.netmgt.provision.detector.simple.response.MultilineOrientedResponse;
import org.opennms.netmgt.provision.support.Client;
import org.opennms.netmgt.provision.support.trustmanager.RelaxedX509TrustManager;

public class SSLClient
extends MultilineOrientedClient
implements Client<LineOrientedRequest, MultilineOrientedResponse> {
    @Override
    public void connect(InetAddress address, int port, int timeout) throws IOException {
        this.m_socket = this.getWrappedSocket(address, port, timeout);
        this.setOutput(this.m_socket.getOutputStream());
        this.setInput(new BufferedReader(new InputStreamReader(this.m_socket.getInputStream())));
    }

    protected Socket getWrappedSocket(InetAddress address, int port, int timeout) throws IOException {
        Socket socket = new Socket();
        socket.connect(new InetSocketAddress(address, port), timeout);
        socket.setSoTimeout(timeout);
        try {
            return this.wrapSocket(socket, InetAddressUtils.str((InetAddress)address), port);
        }
        catch (Exception e) {
            LogUtils.debugf((Object)this, (Throwable)e, (String)"Unable to wrap socket in SSL.", (Object[])new Object[0]);
            return null;
        }
    }

    protected Socket wrapSocket(Socket socket, String hostAddress, int port) throws Exception {
        SSLSocketFactory sslSF = null;
        TrustManager[] tm = new TrustManager[]{new RelaxedX509TrustManager()};
        SSLContext sslContext = SSLContext.getInstance("SSL");
        sslContext.init(null, tm, new SecureRandom());
        sslSF = sslContext.getSocketFactory();
        LogUtils.debugf((Object)this, (String)"SSL port: %d", (Object[])new Object[]{port});
        Socket sslSocket = sslSF.createSocket(socket, hostAddress, port, true);
        return sslSocket;
    }
}

