/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.simple.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.SecureRandom;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.provision.detector.simple.request.NrpeRequest;
import org.opennms.netmgt.provision.support.Client;
import org.opennms.netmgt.provision.support.nrpe.NrpePacket;
import org.opennms.netmgt.provision.support.trustmanager.RelaxedX509TrustManager;

public class NrpeClient
implements Client<NrpeRequest, NrpePacket> {
    private static final String[] ADH_CIPHER_SUITES = new String[]{"TLS_DH_anon_WITH_AES_128_CBC_SHA"};
    private Socket m_socket;
    private int m_padding = 2;
    private boolean m_useSsl = true;
    private OutputStream m_out;
    private InputStream m_in;

    public void close() {
        Socket socket = this.m_socket;
        this.m_socket = null;
        try {
            if (socket != null) {
                socket.close();
            }
        }
        catch (IOException e) {
            LogUtils.debugf((Object)this, (Throwable)e, (String)"failed to close socket", (Object[])new Object[0]);
        }
    }

    public void connect(InetAddress address, int port, int timeout) throws IOException, Exception {
        this.m_socket = this.getWrappedSocket(address, port, timeout);
        this.setOutput(this.m_socket.getOutputStream());
        this.setInput(this.m_socket.getInputStream());
    }

    protected Socket getWrappedSocket(InetAddress address, int port, int timeout) throws IOException {
        Socket socket = new Socket();
        socket.connect(new InetSocketAddress(address, port), timeout);
        socket.setSoTimeout(timeout);
        try {
            return this.wrapSocket(socket, InetAddressUtils.str((InetAddress)address), port);
        }
        catch (Exception e) {
            LogUtils.debugf((Object)this, (Throwable)e, (String)"an error occurred while SSL-wrapping a socket (%s:%d)", (Object[])new Object[]{address, port});
            return null;
        }
    }

    protected Socket wrapSocket(Socket socket, String hostAddress, int port) throws Exception {
        if (!this.isUseSsl()) {
            return socket;
        }
        SSLSocketFactory sslSF = null;
        TrustManager[] tm = new TrustManager[]{new RelaxedX509TrustManager()};
        SSLContext sslContext = SSLContext.getInstance("SSL");
        sslContext.init(null, tm, new SecureRandom());
        sslSF = sslContext.getSocketFactory();
        Socket wrappedSocket = sslSF.createSocket(socket, hostAddress, port, true);
        SSLSocket sslSocket = (SSLSocket)wrappedSocket;
        sslSocket.setEnabledCipherSuites(ADH_CIPHER_SUITES);
        return wrappedSocket;
    }

    public NrpePacket receiveBanner() throws IOException, Exception {
        return this.receiveResponse();
    }

    public NrpePacket sendRequest(NrpeRequest request) throws IOException, Exception {
        request.send(this.getOutput());
        return this.receiveResponse();
    }

    private NrpePacket receiveResponse() throws Exception {
        NrpePacket response = NrpePacket.receivePacket(this.getInput(), this.getPadding());
        LogUtils.infof((Object)this, (String)("what is response: " + response.getResultCode()), (Object[])new Object[0]);
        return response;
    }

    public void setPadding(int padding) {
        this.m_padding = padding;
    }

    public int getPadding() {
        return this.m_padding;
    }

    public void setUseSsl(boolean useSsl) {
        this.m_useSsl = useSsl;
    }

    public boolean isUseSsl() {
        return this.m_useSsl;
    }

    public void setOutput(OutputStream out) {
        this.m_out = out;
    }

    public OutputStream getOutput() {
        return this.m_out;
    }

    public void setInput(InputStream in) {
        this.m_in = in;
    }

    public InputStream getInput() {
        return this.m_in;
    }
}

