/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.simple.client;

import com.novell.ldap.LDAPConnection;
import com.novell.ldap.LDAPSocketFactory;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.provision.detector.simple.client.LineOrientedClient;

public class LdapDetectorClient
extends LineOrientedClient {
    @Override
    public void connect(InetAddress address, int port, int timeout) throws IOException, Exception {
        super.connect(address, port, timeout);
        LDAPConnection lc = new LDAPConnection((LDAPSocketFactory)new TimeoutLDAPSocket(timeout));
        lc.connect(InetAddressUtils.str((InetAddress)address), port);
    }

    private static class TimeoutLDAPSocket
    implements LDAPSocketFactory {
        private final int m_timeout;
        private Socket m_socket;

        public TimeoutLDAPSocket(int timeout) {
            this.m_timeout = timeout;
        }

        public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
            this.m_socket = new Socket(host, port);
            this.m_socket.setSoTimeout(this.m_timeout);
            return this.m_socket;
        }
    }
}

