/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.support.codec;

import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.CumulativeProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.provision.detector.simple.response.LineOrientedResponse;

public class TcpLineDecoder
extends CumulativeProtocolDecoder {
    private Charset m_charset;

    public TcpLineDecoder(Charset charset) {
        this.setCharset(charset);
    }

    private void setCharset(Charset charset) {
        this.m_charset = charset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doDecode(IoSession session, IoBuffer in, ProtocolDecoderOutput out) throws Exception {
        int start = in.position();
        int previous = 0;
        while (in.hasRemaining()) {
            byte current = in.get();
            if (previous == 13 && current == 10) {
                int position = in.position();
                int limit = in.limit();
                try {
                    in.position(start);
                    in.limit(position);
                    LogUtils.debugf((Object)((Object)this), (String)"slice: %s", (Object[])new Object[]{in.slice()});
                    out.write(this.parseCommand(in.slice()));
                }
                finally {
                    in.position(position);
                    in.limit(limit);
                }
                return true;
            }
            previous = current;
        }
        in.position(start);
        out.write(this.parseCommand(in.slice()));
        return false;
    }

    protected Object parseCommand(IoBuffer in) {
        String outputStr = null;
        try {
            outputStr = in.getString(this.getCharset().newDecoder());
        }
        catch (CharacterCodingException e) {
            outputStr = this.convertToString(in);
        }
        return new LineOrientedResponse(outputStr);
    }

    private String convertToString(IoBuffer in) {
        StringBuffer sb = new StringBuffer();
        while (in.hasRemaining()) {
            byte current = in.get();
            sb.append((char)current);
        }
        return sb.toString();
    }

    public Charset getCharset() {
        return this.m_charset;
    }

    public void finishDecode(IoSession session, ProtocolDecoderOutput out) {
        if (session.getReadMessages() == 0L) {
            out.write((Object)new LineOrientedResponse("TCP Failed to send Banner"));
        }
    }
}

