/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.simple;

import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.provision.detector.simple.request.LineOrientedRequest;
import org.opennms.netmgt.provision.detector.simple.response.MultilineHttpResponse;
import org.opennms.netmgt.provision.support.AsyncBasicDetector;
import org.opennms.netmgt.provision.support.AsyncClientConversation;
import org.opennms.netmgt.provision.support.codec.MultilineHttpProtocolFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MultilineHttpDetector
extends AsyncBasicDetector<LineOrientedRequest, MultilineHttpResponse> {
    private static final String DEFAULT_SERVICE_NAME = "HTTP";
    private static final int DEFAULT_PORT = 80;
    private static String DEFAULT_URL = "/";
    private static int DEFAULT_MAX_RET_CODE = 399;
    private String m_url;
    private int m_maxRetCode;
    private boolean m_checkRetCode = false;

    public MultilineHttpDetector() {
        super(DEFAULT_SERVICE_NAME, 80);
        this.contructDefaults();
    }

    public MultilineHttpDetector(String serviceName, int port) {
        super(serviceName, port);
        this.contructDefaults();
    }

    private void contructDefaults() {
        this.setProtocolCodecFilter(new ProtocolCodecFilter((ProtocolCodecFactory)new MultilineHttpProtocolFactory()));
        this.setUrl(DEFAULT_URL);
        this.setMaxRetCode(DEFAULT_MAX_RET_CODE);
    }

    protected void onInit() {
        this.send(this.request(this.httpCommand("GET")), this.contains(DEFAULT_SERVICE_NAME, this.getUrl(), this.isCheckRetCode(), this.getMaxRetCode()));
    }

    protected String httpCommand(String command) {
        return String.format("%s %s  HTTP/1.0\r\n\r\n", command, this.getUrl());
    }

    protected LineOrientedRequest request(String command) {
        return new LineOrientedRequest(command);
    }

    protected AsyncClientConversation.ResponseValidator<MultilineHttpResponse> contains(final String pattern, final String url, final boolean isCheckCode, final int maxRetCode) {
        return new AsyncClientConversation.ResponseValidator<MultilineHttpResponse>(){

            public boolean validate(MultilineHttpResponse message) {
                try {
                    return message.validateResponse(pattern, url, isCheckCode, maxRetCode);
                }
                catch (Exception e) {
                    LogUtils.debugf((Object)this, (Throwable)e, (String)"Unable to validate response", (Object[])new Object[0]);
                    return false;
                }
            }
        };
    }

    public void setUrl(String url) {
        this.m_url = url;
    }

    public String getUrl() {
        return this.m_url;
    }

    public void setMaxRetCode(int maxRetCode) {
        this.m_maxRetCode = maxRetCode;
    }

    public int getMaxRetCode() {
        return this.m_maxRetCode;
    }

    public void setCheckRetCode(boolean checkRetCode) {
        this.m_checkRetCode = checkRetCode;
    }

    public boolean isCheckRetCode() {
        return this.m_checkRetCode;
    }
}

