/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.simple;

import org.opennms.netmgt.provision.detector.simple.client.NrpeClient;
import org.opennms.netmgt.provision.detector.simple.request.NrpeRequest;
import org.opennms.netmgt.provision.support.BasicDetector;
import org.opennms.netmgt.provision.support.Client;
import org.opennms.netmgt.provision.support.ResponseValidator;
import org.opennms.netmgt.provision.support.nrpe.NrpePacket;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class NrpeDetector
extends BasicDetector<NrpeRequest, NrpePacket> {
    private static final String DEFAULT_SERVICE_NAME = "NRPE";
    private static final int DEFAULT_PORT = 5666;
    private static final boolean DEFAULT_USE_SSL = true;
    private boolean m_useSsl = true;
    private int m_padding = 2;
    private String m_command = "_NRPE_CHECK";

    public NrpeDetector() {
        super(DEFAULT_SERVICE_NAME, 5666);
    }

    public NrpeDetector(String serviceName, int port) {
        super(serviceName, port);
    }

    protected void onInit() {
        this.send(this.request(this.m_command), NrpeDetector.resultCodeEquals(0));
    }

    private static ResponseValidator<NrpePacket> resultCodeEquals(final int desiredResultCode) {
        return new ResponseValidator<NrpePacket>(){

            public boolean validate(NrpePacket response) {
                return response.getResultCode() == desiredResultCode;
            }
        };
    }

    private NrpeRequest request(String command) {
        NrpePacket packet = new NrpePacket(1, 0, command);
        byte[] b = packet.buildPacket(this.getPadding());
        return new NrpeRequest(b);
    }

    protected Client<NrpeRequest, NrpePacket> getClient() {
        NrpeClient client = new NrpeClient();
        client.setPadding(this.getPadding());
        client.setUseSsl(this.isUseSsl());
        return client;
    }

    public void setUseSsl(boolean useSsl) {
        this.m_useSsl = useSsl;
    }

    public boolean isUseSsl() {
        return this.m_useSsl;
    }

    public void setPadding(int padding) {
        this.m_padding = padding;
    }

    public int getPadding() {
        return this.m_padding;
    }

    public void setCommand(String command) {
        this.m_command = command;
    }

    public String getCommand() {
        return this.m_command;
    }
}

