/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.simple.response;

import org.opennms.core.utils.ThreadCategory;

public class TrivialTimeResponse {
    boolean available = false;

    public TrivialTimeResponse() {
    }

    public TrivialTimeResponse(int remoteTime, int localTime, int allowedSkew) {
        this.log().debug("qualifyTime: checking remote time " + remoteTime + " against local time " + localTime + " with max skew of " + allowedSkew);
        if (localTime - remoteTime > allowedSkew || remoteTime - localTime > allowedSkew) {
            this.log().debug("Remote time is " + (localTime > remoteTime ? "" + (localTime - remoteTime) + " seconds slow" : "" + (remoteTime - localTime) + " seconds fast"));
        }
        if (localTime > remoteTime && localTime - remoteTime > allowedSkew) {
            this.log().debug("Remote time is " + (localTime - remoteTime) + " seconds behind local, more than the allowable " + allowedSkew);
        } else if (remoteTime > localTime && remoteTime - localTime > allowedSkew) {
            this.log().debug("Remote time is " + (remoteTime - localTime) + " seconds ahead of local, more than the allowable " + allowedSkew);
        } else {
            this.available = true;
        }
    }

    public boolean isAvailable() {
        return this.available;
    }

    protected ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }
}

