/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.simple.client;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.provision.detector.simple.request.LineOrientedRequest;
import org.opennms.netmgt.provision.detector.simple.response.MultilineOrientedResponse;
import org.opennms.netmgt.provision.support.Client;

public class MultilineOrientedClient
implements Client<LineOrientedRequest, MultilineOrientedResponse> {
    protected Socket m_socket;
    private OutputStream m_out;
    private BufferedReader m_in;

    public void close() {
        Socket socket = this.m_socket;
        this.m_socket = null;
        try {
            if (socket != null) {
                socket.close();
            }
        }
        catch (IOException e) {
            LogUtils.debugf((Object)this, (Throwable)e, (String)"Unable to close socket", (Object[])new Object[0]);
        }
    }

    public void connect(InetAddress address, int port, int timeout) throws IOException {
        Socket socket = new Socket();
        socket.connect(new InetSocketAddress(address, port), timeout);
        socket.setSoTimeout(timeout);
        this.setInput(new BufferedReader(new InputStreamReader(socket.getInputStream())));
        this.setOutput(socket.getOutputStream());
        this.m_socket = socket;
    }

    public MultilineOrientedResponse receiveBanner() throws IOException {
        return this.receiveResponse();
    }

    public MultilineOrientedResponse sendRequest(LineOrientedRequest request) throws IOException {
        request.send(this.getOutput());
        return this.receiveResponse();
    }

    private MultilineOrientedResponse receiveResponse() throws IOException {
        MultilineOrientedResponse response = new MultilineOrientedResponse();
        response.receive(this.getInput());
        return response;
    }

    public void setInput(BufferedReader in) {
        this.m_in = in;
    }

    public BufferedReader getInput() {
        return this.m_in;
    }

    public void setOutput(OutputStream out) {
        this.m_out = out;
    }

    public OutputStream getOutput() {
        return this.m_out;
    }
}

