/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.jdbc.response;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;

public class JDBCResponse {
    private ResultSet m_result;
    private boolean m_isValidProcedureCall = false;

    public void receive(Connection conn) throws SQLException {
        DatabaseMetaData metadata = conn.getMetaData();
        this.log().debug((Object)"got database metadata");
        this.m_result = metadata.getCatalogs();
    }

    public boolean resultSetNotNull() {
        try {
            while (this.m_result.next()) {
                this.m_result.getString(1);
                if (!this.log().isDebugEnabled()) continue;
                this.log().debug((Object)("Metadata catalog: '" + this.m_result.getString(1) + "'"));
            }
            this.m_result.close();
            return true;
        }
        catch (SQLException e) {
            this.log().info((Object)"Unable to get result set", (Throwable)e);
            return false;
        }
    }

    public boolean validProcedureCall() {
        return this.isValidProcedureCall();
    }

    public void setValidProcedureCall(boolean isValidProcedureCall) {
        this.m_isValidProcedureCall = isValidProcedureCall;
    }

    public boolean isValidProcedureCall() {
        return this.m_isValidProcedureCall;
    }

    public Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }
}

