/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.jdbc.client;

import java.io.IOException;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.provision.detector.jdbc.request.JDBCRequest;
import org.opennms.netmgt.provision.detector.jdbc.response.JDBCResponse;
import org.opennms.netmgt.provision.support.Client;
import org.opennms.netmgt.provision.support.jdbc.DBTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCClient
implements Client<JDBCRequest, JDBCResponse> {
    private String m_dbDriver;
    private String m_user;
    private String m_password;
    private String m_url;
    private Connection m_connection;

    public void close() {
        if (this.m_connection != null) {
            try {
                this.m_connection.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public void connect(InetAddress address, int port, int timeout) throws IOException, Exception {
        this.log().info((Object)("connecting to JDBC on " + address));
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("Loading JDBC driver: '" + this.getDbDriver() + "'"));
        }
        Driver driver = (Driver)Class.forName(this.getDbDriver()).newInstance();
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("JDBC driver loaded: '" + this.getDbDriver() + "'"));
        }
        String url = DBTools.constructUrl(this.getUrl(), address.getCanonicalHostName());
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("Constructed JDBC url: '" + url + "'"));
        }
        Properties props = new Properties();
        props.setProperty("user", this.getUser());
        props.setProperty("password", this.getPassword());
        props.setProperty("timeout", String.valueOf(timeout / 1000));
        this.m_connection = driver.connect(url, props);
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("Got database connection: '" + this.m_connection + "' (" + url + ", " + this.getUser() + ", " + this.getPassword() + ")"));
        }
    }

    public JDBCResponse receiveBanner() throws IOException, Exception {
        JDBCResponse response = new JDBCResponse();
        response.receive(this.m_connection);
        return response;
    }

    public JDBCResponse sendRequest(JDBCRequest request) throws IOException, Exception {
        return request.send(this.m_connection);
    }

    public void setDbDriver(String dbDriver) {
        this.m_dbDriver = dbDriver;
    }

    public String getDbDriver() {
        return this.m_dbDriver;
    }

    public void setUser(String user) {
        this.m_user = user;
    }

    public String getUser() {
        return this.m_user;
    }

    public void setPassword(String password) {
        this.m_password = password;
    }

    public String getPassword() {
        return this.m_password;
    }

    public void setUrl(String url) {
        this.m_url = url;
    }

    public String getUrl() {
        return this.m_url;
    }

    public Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }
}

