/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.jdbc;

import org.opennms.netmgt.provision.detector.jdbc.AbstractJdbcDetector;
import org.opennms.netmgt.provision.detector.jdbc.request.JDBCRequest;
import org.opennms.netmgt.provision.detector.jdbc.response.JDBCResponse;
import org.opennms.netmgt.provision.support.ClientConversation;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class JdbcQueryDetector
extends AbstractJdbcDetector {
    private String m_sqlQuery;

    protected JdbcQueryDetector() {
        super("JdbcQueryDetector", 3306);
    }

    protected void onInit() {
        this.expectBanner(this.resultSetNotNull());
        this.send(this.sqlQuery(this.getSqlQuery()), this.isValidQuery());
    }

    private ClientConversation.ResponseValidator<JDBCResponse> isValidQuery() {
        return new ClientConversation.ResponseValidator<JDBCResponse>(){

            public boolean validate(JDBCResponse response) throws Exception {
                return response.isValidQuery();
            }
        };
    }

    private ClientConversation.RequestBuilder<JDBCRequest> sqlQuery(final String sqlQuery) {
        return new ClientConversation.RequestBuilder<JDBCRequest>(){

            public JDBCRequest getRequest() throws Exception {
                JDBCRequest request = new JDBCRequest();
                request.setSqyQuery(sqlQuery);
                return request;
            }
        };
    }

    public void setSqlQuery(String sqlQuery) {
        this.m_sqlQuery = sqlQuery;
    }

    public String getSqlQuery() {
        return this.m_sqlQuery;
    }
}

