/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.generic;

import org.opennms.netmgt.provision.detector.generic.client.GpClient;
import org.opennms.netmgt.provision.detector.generic.request.GpRequest;
import org.opennms.netmgt.provision.detector.generic.response.GpResponse;
import org.opennms.netmgt.provision.support.BasicDetector;
import org.opennms.netmgt.provision.support.Client;
import org.opennms.netmgt.provision.support.ClientConversation;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
@Scope(value="prototype")
public class GpDetector
extends BasicDetector<GpRequest, GpResponse> {
    private static String DEFAULT_HOPTION = "--hostname";
    private static String DEFAULT_TOPTION = "--timeout";
    private String m_script;
    private String m_args;
    private String m_banner;
    private String m_match;
    private String m_hoption = DEFAULT_HOPTION;
    private String m_toption = DEFAULT_TOPTION;

    protected GpDetector() {
        super("GP", 0);
    }

    protected Client<GpRequest, GpResponse> getClient() {
        GpClient client = new GpClient();
        client.setScript(this.getScript());
        client.setArgs(this.getArgs());
        client.setBanner(this.getBanner());
        client.setMatch(this.getMatch());
        client.setHoption(this.getHoption());
        client.setToption(this.getToption());
        return client;
    }

    protected void onInit() {
        this.expectBanner(this.responseMatches(this.getBanner()));
    }

    private ClientConversation.ResponseValidator<GpResponse> responseMatches(final String banner) {
        return new ClientConversation.ResponseValidator<GpResponse>(){

            public boolean validate(GpResponse response) throws Exception {
                return response.validate(banner);
            }
        };
    }

    public void setScript(String script) {
        this.m_script = script;
    }

    public String getScript() {
        return this.m_script;
    }

    public void setArgs(String args) {
        this.m_args = args;
    }

    public String getArgs() {
        return this.m_args;
    }

    public void setBanner(String banner) {
        this.m_banner = banner;
    }

    public String getBanner() {
        return this.m_banner;
    }

    public void setMatch(String match) {
        this.m_match = match;
    }

    public String getMatch() {
        return this.m_match;
    }

    public void setHoption(String hoption) {
        this.m_hoption = hoption;
    }

    public String getHoption() {
        return this.m_hoption;
    }

    public void setToption(String toption) {
        this.m_toption = toption;
    }

    public String getToption() {
        return this.m_toption;
    }
}

