/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.dhcp;

import org.opennms.netmgt.provision.detector.dhcp.client.DhcpClient;
import org.opennms.netmgt.provision.detector.dhcp.request.DhcpRequest;
import org.opennms.netmgt.provision.detector.dhcp.response.DhcpResponse;
import org.opennms.netmgt.provision.support.BasicDetector;
import org.opennms.netmgt.provision.support.Client;
import org.opennms.netmgt.provision.support.ClientConversation;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
@Scope(value="prototype")
public class DhcpDetector
extends BasicDetector<DhcpRequest, DhcpResponse> {
    private static final int DEFAULT_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 3000;

    public DhcpDetector() {
        super("DCHP", 0);
        this.setTimeout(3000);
        this.setRetries(0);
    }

    protected void onInit() {
        this.expectBanner(this.responseTimeGreaterThan(-1L));
    }

    private ClientConversation.ResponseValidator<DhcpResponse> responseTimeGreaterThan(final long num) {
        return new ClientConversation.ResponseValidator<DhcpResponse>(){

            public boolean validate(DhcpResponse response) throws Exception {
                return response.validate(num);
            }
        };
    }

    protected Client<DhcpRequest, DhcpResponse> getClient() {
        DhcpClient client = new DhcpClient();
        client.setRetries(1);
        return client;
    }
}

