/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.bsf;

import org.opennms.netmgt.provision.detector.bsf.client.BSFClient;
import org.opennms.netmgt.provision.detector.bsf.request.BSFRequest;
import org.opennms.netmgt.provision.detector.bsf.response.BSFResponse;
import org.opennms.netmgt.provision.support.BasicDetector;
import org.opennms.netmgt.provision.support.Client;
import org.opennms.netmgt.provision.support.ResponseValidator;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class BSFDetector
extends BasicDetector<BSFRequest, BSFResponse> {
    private String m_fileName;
    private String m_langClass;
    private String m_bsfEngine;
    private String m_fileExtensions = "";
    private String m_runType = "eval";

    protected BSFDetector() {
        super("BSF", 0);
    }

    protected Client<BSFRequest, BSFResponse> getClient() {
        BSFClient client = new BSFClient();
        client.setServiceName(this.getServiceName());
        client.setFileName(this.getFileName());
        client.setLangClass(this.getLangClass());
        client.setBsfEngine(this.getBsfEngine());
        client.setFileExtensions(this.getFileExtensions().split(","));
        client.setRunType(this.getRunType());
        return client;
    }

    protected void onInit() {
        this.expectBanner(BSFDetector.responseMatches("OK"));
    }

    private static ResponseValidator<BSFResponse> responseMatches(final String banner) {
        return new ResponseValidator<BSFResponse>(){

            public boolean validate(BSFResponse response) {
                return response.validate(banner);
            }
        };
    }

    public String getFileName() {
        return this.m_fileName;
    }

    public void setFileName(String fileName) {
        this.m_fileName = fileName;
    }

    public String getLangClass() {
        return this.m_langClass;
    }

    public void setLangClass(String langClass) {
        this.m_langClass = langClass;
    }

    public String getBsfEngine() {
        return this.m_bsfEngine;
    }

    public void setBsfEngine(String bsfEngine) {
        this.m_bsfEngine = bsfEngine;
    }

    public String getFileExtensions() {
        return this.m_fileExtensions;
    }

    public void setFileExtensions(String fileExtensions) {
        this.m_fileExtensions = fileExtensions;
    }

    public String getRunType() {
        return this.m_runType;
    }

    public void setRunType(String runType) {
        this.m_runType = runType;
    }
}

