/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.bsf.client;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;
import org.apache.bsf.util.IOUtils;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.provision.detector.bsf.request.BSFRequest;
import org.opennms.netmgt.provision.detector.bsf.response.BSFResponse;
import org.opennms.netmgt.provision.support.Client;

public class BSFClient
implements Client<BSFRequest, BSFResponse> {
    private String m_serviceName;
    private String m_fileName;
    private String m_langClass;
    private String m_bsfEngine;
    private String[] m_fileExtensions = new String[0];
    private String m_runType = "eval";
    private HashMap<String, String> m_results;

    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(InetAddress address, int port, int timeout) throws IOException, Exception {
        this.m_results = new HashMap();
        BSFManager bsfManager = new BSFManager();
        File file = new File(this.m_fileName);
        Map<String, Object> map = this.getParametersMap();
        try {
            if (this.m_langClass == null) {
                this.m_langClass = BSFManager.getLangFromFilename((String)this.m_fileName);
            }
            if (this.m_bsfEngine != null && this.m_langClass != null && this.m_fileExtensions.length > 0) {
                BSFManager.registerScriptingEngine((String)this.m_langClass, (String)this.m_bsfEngine, (String[])this.m_fileExtensions);
            }
            if (file.exists() && file.canRead()) {
                String code = IOUtils.getStringFromReader((Reader)new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
                bsfManager.declareBean("map", map, Map.class);
                bsfManager.declareBean("ip_addr", (Object)address.getHostAddress(), String.class);
                bsfManager.declareBean("svc_name", (Object)this.m_serviceName, String.class);
                bsfManager.declareBean("results", this.m_results, HashMap.class);
                for (Map.Entry<String, Object> entry : map.entrySet()) {
                    bsfManager.declareBean(entry.getKey(), entry.getValue(), String.class);
                }
                LogUtils.infof((Object)this, (String)"Executing %s for %s", (Object[])new Object[]{this.m_langClass, file.getAbsoluteFile()});
                if ("eval".equals(this.m_runType)) {
                    this.m_results.put("status", bsfManager.eval(this.m_langClass, "BSFDetector", 0, 0, (Object)code).toString());
                } else if ("exec".equals(this.m_runType)) {
                    bsfManager.exec(this.m_langClass, "BSFDetector", 0, 0, (Object)code);
                } else {
                    LogUtils.warnf((Object)this, (String)"Invalid run-type parameter value '%s' for service '%s'. Only 'eval' and 'exec' are supported.", (Object[])new Object[]{this.m_runType, this.m_serviceName});
                    throw new RuntimeException("Invalid run-type '" + this.m_runType + "'");
                }
                if ("exec".equals(this.m_runType) && !this.m_results.containsKey("status")) {
                    LogUtils.warnf((Object)this, (String)"The exec script '%s' for service '%s' never put a 'status' entry in the 'results' bean. Exec scripts should put this entry with a value of 'OK' for up.", (Object[])new Object[]{this.m_fileName, this.m_serviceName});
                }
            } else {
                LogUtils.warnf((Object)this, (String)"Cannot locate or read BSF script file '%s'. Marking service '%s' down.", (Object[])new Object[]{this.m_fileName, this.m_serviceName});
            }
        }
        catch (BSFException e) {
            this.m_results.clear();
            LogUtils.warnf((Object)this, (Throwable)e, (String)"BSFDetector poll for service '%s' failed with BSFException: %s", (Object[])new Object[]{this.m_serviceName, e.getMessage()});
        }
        catch (FileNotFoundException e) {
            this.m_results.clear();
            LogUtils.warnf((Object)this, (String)"Could not find BSF script file '%s'. Marking service '%s' down.", (Object[])new Object[]{this.m_fileName, this.m_serviceName});
        }
        catch (IOException e) {
            this.m_results.clear();
            LogUtils.warnf((Object)this, (Throwable)e, (String)"BSFDetector poll for service '%s' failed with IOException: %s", (Object[])new Object[]{this.m_serviceName, e.getMessage()});
        }
        catch (Throwable e) {
            this.m_results.clear();
            LogUtils.warnf((Object)this, (Throwable)e, (String)"BSFDetector poll for service '%s' failed with unexpected throwable: %s", (Object[])new Object[]{this.m_serviceName, e.getMessage()});
        }
        finally {
            bsfManager.terminate();
        }
    }

    public BSFResponse receiveBanner() throws IOException, Exception {
        LogUtils.debugf((Object)this, (String)"Results: %s", (Object[])new Object[]{this.m_results});
        BSFResponse response = new BSFResponse(this.m_results);
        return response;
    }

    public BSFResponse sendRequest(BSFRequest request) throws IOException, Exception {
        return null;
    }

    public String getServiceName() {
        return this.m_serviceName;
    }

    public void setServiceName(String serviceName) {
        this.m_serviceName = serviceName;
    }

    public String getFileName() {
        return this.m_fileName;
    }

    public void setFileName(String fileName) {
        this.m_fileName = fileName;
    }

    public String getLangClass() {
        return this.m_langClass;
    }

    public void setLangClass(String langClass) {
        this.m_langClass = langClass;
    }

    public String getBsfEngine() {
        return this.m_bsfEngine;
    }

    public void setBsfEngine(String bsfEngine) {
        this.m_bsfEngine = bsfEngine;
    }

    public String[] getFileExtensions() {
        return this.m_fileExtensions;
    }

    public void setFileExtensions(String[] fileExtensions) {
        this.m_fileExtensions = fileExtensions;
    }

    public String getRunType() {
        return this.m_runType;
    }

    public void setRunType(String runType) {
        this.m_runType = runType;
    }

    private Map<String, Object> getParametersMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("file-name", this.getFileName());
        map.put("lang-class", this.getLangClass());
        map.put("bsf-engine", this.getBsfEngine());
        map.put("file-extensions", this.getFileExtensions());
        map.put("run-type", this.getRunType());
        return map;
    }
}

