/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import java.net.InetAddress;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.opennms.core.collections.LazySet;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.dao.api.MonitoringLocationUtils;
import org.opennms.netmgt.dao.api.ResourceStorageDao;
import org.opennms.netmgt.dao.support.LazyResourceAttributeLoader;
import org.opennms.netmgt.dao.support.NodeResourceType;
import org.opennms.netmgt.model.OnmsEntity;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.OnmsResourceType;
import org.opennms.netmgt.model.ResourcePath;
import org.opennms.netmgt.model.ResourceTypeUtils;
import org.springframework.orm.ObjectRetrievalFailureException;

public final class ResponseTimeResourceType
implements OnmsResourceType {
    private final ResourceStorageDao m_resourceStorageDao;
    private final IpInterfaceDao m_ipInterfaceDao;

    public ResponseTimeResourceType(ResourceStorageDao resourceStorageDao, IpInterfaceDao ipInterfaceDao) {
        this.m_resourceStorageDao = resourceStorageDao;
        this.m_ipInterfaceDao = ipInterfaceDao;
    }

    public String getLabel() {
        return "Response Time";
    }

    public String getName() {
        return "responseTime";
    }

    public String getLinkForResource(OnmsResource resource) {
        return "element/interface.jsp?node=" + resource.getParent().getName() + "&intf=" + resource.getName();
    }

    public boolean isResourceTypeOnParent(OnmsResource parent) {
        return this.getResourcesForParent(parent, true).size() > 0;
    }

    public List<OnmsResource> getResourcesForParent(OnmsResource parent) {
        return this.getResourcesForParent(parent, false);
    }

    public OnmsResource getChildByName(OnmsResource parent, String ipAddress) {
        OnmsNode node = ResourceTypeUtils.getNodeFromResource((OnmsResource)parent);
        String locationName = MonitoringLocationUtils.getLocationNameOrNullIfDefault((OnmsNode)node);
        OnmsIpInterface matchingIf = this.m_ipInterfaceDao.get(node, ipAddress);
        if (matchingIf == null) {
            throw new ObjectRetrievalFailureException(OnmsIpInterface.class, (Object)("No interface with ipAddr " + ipAddress + " could be found on node with id " + node.getId()));
        }
        ResourcePath path = ResponseTimeResourceType.getInterfacePath(locationName, ipAddress);
        if (!this.m_resourceStorageDao.exists(path, 0)) {
            throw new ObjectRetrievalFailureException(OnmsResource.class, (Object)("No metrics found in parent path '" + parent.getPath() + "'"));
        }
        OnmsResource resource = this.createResource(locationName, matchingIf, ipAddress, path);
        resource.setParent(parent);
        return resource;
    }

    private List<OnmsResource> getResourcesForParent(OnmsResource parent, boolean stopAfterFirst) {
        if (!NodeResourceType.isNode(parent)) {
            return Collections.emptyList();
        }
        OnmsNode node = ResourceTypeUtils.getNodeFromResource((OnmsResource)parent);
        String locationName = MonitoringLocationUtils.getLocationNameOrNullIfDefault((OnmsNode)node);
        LinkedList<OnmsResource> resources = new LinkedList<OnmsResource>();
        for (OnmsIpInterface i : node.getIpInterfaces()) {
            String ipAddr = InetAddressUtils.str((InetAddress)i.getIpAddress());
            ResourcePath path = ResponseTimeResourceType.getInterfacePath(locationName, ipAddr);
            if (!this.m_resourceStorageDao.exists(path, 0)) continue;
            resources.add(this.createResource(locationName, i, ipAddr, path));
            if (!stopAfterFirst) continue;
            break;
        }
        return resources;
    }

    private OnmsResource createResource(String location, OnmsIpInterface ipInterface, String ipAddr, ResourcePath path) {
        LazyResourceAttributeLoader loader = new LazyResourceAttributeLoader(this.m_resourceStorageDao, path);
        LazySet set = new LazySet((LazySet.Loader)loader);
        OnmsResource resource = new OnmsResource(ipAddr, ipAddr, (OnmsResourceType)this, (Set)set, path);
        resource.setEntity((OnmsEntity)ipInterface);
        return resource;
    }

    public static ResourcePath getInterfacePath(String location, String ipAddr) {
        if (location == null) {
            return new ResourcePath(new String[]{"response", ipAddr});
        }
        return new ResourcePath(new String[]{"response", ResourcePath.sanitize((String)location), ipAddr});
    }
}

