/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import java.io.Serializable;
import org.opennms.netmgt.dao.api.InterfaceToNodeCache;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.events.api.annotations.EventHandler;
import org.opennms.netmgt.events.api.annotations.EventListener;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.xml.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@EventListener(name="OpenNMS.InterfaceToNodeCache", logPrefix="eventd")
public class InterfaceToNodeCacheEventProcessor
implements InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(InterfaceToNodeCacheEventProcessor.class);
    @Autowired
    private InterfaceToNodeCache m_cache;
    @Autowired
    private NodeDao m_nodeDao;

    public void afterPropertiesSet() throws Exception {
    }

    @EventHandler(uei="uei.opennms.org/nodes/nodeGainedInterface")
    @Transactional
    public void handleNodeGainedInterface(Event event) {
        LOG.debug("Received event: {}", (Object)event.getUei());
        Long nodeId = event.getNodeid();
        if (nodeId == null) {
            LOG.error("uei.opennms.org/nodes/nodeGainedInterface: Event with no node ID: " + event.toString());
            return;
        }
        OnmsNode node = (OnmsNode)this.m_nodeDao.get((Serializable)Integer.valueOf(nodeId.intValue()));
        if (node == null) {
            LOG.warn("uei.opennms.org/nodes/nodeGainedInterface: Cannot find node in DB: " + nodeId);
            return;
        }
        this.m_cache.setNodeId(node.getLocation().getLocationName(), event.getInterfaceAddress(), nodeId.intValue());
    }

    @EventHandler(uei="uei.opennms.org/nodes/interfaceDeleted")
    @Transactional
    public void handleInterfaceDeleted(Event event) {
        LOG.debug("Received event: {}", (Object)event.getUei());
        Long nodeId = event.getNodeid();
        if (nodeId == null) {
            LOG.error("uei.opennms.org/nodes/interfaceDeleted: Event with no node ID: " + event.toString());
            return;
        }
        OnmsNode node = (OnmsNode)this.m_nodeDao.get((Serializable)Integer.valueOf(nodeId.intValue()));
        if (node == null) {
            LOG.warn("uei.opennms.org/nodes/interfaceDeleted: Cannot find node in DB: " + nodeId);
            return;
        }
        this.m_cache.removeNodeId(node.getLocation().getLocationName(), event.getInterfaceAddress(), nodeId.intValue());
    }

    @EventHandler(uei="uei.opennms.org/nodes/interfaceReparented")
    @Transactional
    public void handleInterfaceReparented(Event event) {
        LOG.debug("Received event: {}", (Object)event.getUei());
        String oldNodeId = event.getParm("oldNodeID").getValue().getContent();
        String newNodeId = event.getParm("newNodeID").getValue().getContent();
        if (oldNodeId == null) {
            LOG.error("uei.opennms.org/nodes/interfaceReparented: Event with no node ID: " + event.toString());
            return;
        }
        if (newNodeId == null) {
            LOG.error("uei.opennms.org/nodes/interfaceReparented: Event with no node ID: " + event.toString());
            return;
        }
        OnmsNode oldNode = this.m_nodeDao.get(oldNodeId);
        if (oldNode == null) {
            LOG.warn("uei.opennms.org/nodes/interfaceReparented: Cannot find node in DB: " + oldNodeId);
            return;
        }
        OnmsNode newNode = this.m_nodeDao.get(newNodeId);
        if (newNode == null) {
            LOG.warn("uei.opennms.org/nodes/interfaceReparented: Cannot find node in DB: " + newNodeId);
            return;
        }
        this.m_cache.removeNodeId(oldNode.getLocation().getLocationName(), event.getInterfaceAddress(), oldNode.getId().intValue());
        this.m_cache.setNodeId(newNode.getLocation().getLocationName(), event.getInterfaceAddress(), newNode.getId().intValue());
    }
}

