/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import java.util.Date;
import java.util.List;
import org.opennms.netmgt.dao.api.CdpLinkDao;
import org.opennms.netmgt.dao.hibernate.AbstractDaoHibernate;
import org.opennms.netmgt.model.CdpLink;
import org.opennms.netmgt.model.OnmsNode;
import org.springframework.util.Assert;

public class CdpLinkDaoHibernate
extends AbstractDaoHibernate<CdpLink, Integer>
implements CdpLinkDao {
    public CdpLinkDaoHibernate() {
        super(CdpLink.class);
    }

    public CdpLink get(OnmsNode node, Integer cdpCacheifIndex, Integer cdpCacheDeviceIndex) {
        Assert.notNull((Object)node, (String)"node cannot be null");
        Assert.notNull((Object)cdpCacheifIndex, (String)"cdpCacheifIndex cannot be null");
        Assert.notNull((Object)cdpCacheDeviceIndex, (String)"cdpCacheDeviceIndex cannot be null");
        return (CdpLink)this.findUnique("from CdpLink as cdpLink where cdpLink.node = ? and cdpLink.cdpCacheIfIndex = ? and cdpCacheDeviceIndex = ?", node, cdpCacheifIndex, cdpCacheDeviceIndex);
    }

    public CdpLink get(Integer nodeId, Integer cdpCacheifIndex, Integer cdpCacheDeviceIndex) {
        Assert.notNull((Object)nodeId, (String)"nodeId cannot be null");
        Assert.notNull((Object)cdpCacheifIndex, (String)"cdpCacheifIndex cannot be null");
        Assert.notNull((Object)cdpCacheDeviceIndex, (String)"cdpCacheDeviceIndex cannot be null");
        return (CdpLink)this.findUnique("from CdpLink as cdpLink where cdpLink.node.id = ? and cdpLink.cdpCacheIfIndex = ? and cdpCacheDeviceIndex = ?", nodeId, cdpCacheifIndex, cdpCacheDeviceIndex);
    }

    public List<CdpLink> findByNodeId(Integer nodeId) {
        Assert.notNull((Object)nodeId, (String)"nodeId cannot be null");
        return this.find("from CdpLink cdpLink where cdpLink.node.id = ?", nodeId);
    }

    public void deleteByNodeIdOlderThen(Integer nodeId, Date now) {
        this.getHibernateTemplate().bulkUpdate("delete from CdpLink cdpLink where cdpLink.node.id = ? and cdpLink.cdpLinkLastPollTime < ?", new Object[]{nodeId, now});
    }

    public void deleteByNodeId(Integer nodeId) {
        this.getHibernateTemplate().bulkUpdate("delete from CdpLink cdpLink where cdpLink.node.id = ? ", new Object[]{nodeId});
    }
}

