/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.netmgt.dao.api.MinionDao;
import org.opennms.netmgt.model.minion.OnmsMinion;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-commonConfigs.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath:/META-INF/opennms/applicationContext-databasePopulator.xml", "classpath:/META-INF/opennms/applicationContext-setupIpLike-enabled.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase(dirtiesContext=true)
public class MinionDaoIT {
    @Autowired
    private MinionDao m_minionDao;
    @Autowired
    private JdbcTemplate m_jdbcTemplate;

    @Before
    public void setUp() throws Exception {
        List minions = this.m_minionDao.findAll();
        for (OnmsMinion minion : minions) {
            this.m_minionDao.delete((Object)minion);
        }
        this.m_minionDao.flush();
    }

    @Test
    public void testQueryByLocation() throws Exception {
        Date now = new Date();
        this.m_minionDao.save((Object)new OnmsMinion(UUID.randomUUID().toString(), "TestLocation", "Started", now));
        this.m_minionDao.save((Object)new OnmsMinion(UUID.randomUUID().toString(), "TestLocation", "Stopped", now));
        this.m_minionDao.save((Object)new OnmsMinion(UUID.randomUUID().toString(), "OtherLocation", "Stopped", now));
        Collection testMinions = this.m_minionDao.findByLocation("TestLocation");
        Assert.assertEquals((long)2L, (long)testMinions.size());
    }

    @Test
    @Transactional
    public void testProperties() throws Exception {
        Date now = new Date();
        OnmsMinion a = new OnmsMinion(UUID.randomUUID().toString(), "TestLocation", "Started", now);
        OnmsMinion b = new OnmsMinion(UUID.randomUUID().toString(), "OtherLocation", "Started", now);
        a.getProperties().put("Yes", "No");
        a.setProperty("Up", "Down");
        b.setProperty("Left", "Right");
        b.setProperty("Wrong", "Right");
        this.m_minionDao.save((Object)a);
        this.m_minionDao.save((Object)b);
        this.m_minionDao.flush();
        Assert.assertEquals((Object)4, (Object)this.m_jdbcTemplate.queryForObject("select count(*) from monitoringsystemsproperties", Integer.class));
        Assert.assertEquals((Object)2, (Object)this.m_jdbcTemplate.queryForObject("select count(*) from monitoringsystemsproperties where monitoringsystemid = ?", new Object[]{a.getId()}, Integer.class));
        Assert.assertEquals((Object)2, (Object)this.m_jdbcTemplate.queryForObject("select count(*) from monitoringsystemsproperties where monitoringsystemid = ?", new Object[]{b.getId()}, Integer.class));
        String prop = (String)this.m_minionDao.findById(a.getId()).getProperties().get("Left");
        Assert.assertNull((Object)prop);
        prop = (String)this.m_minionDao.findById(b.getId()).getProperties().get("Left");
        Assert.assertNotNull((Object)prop);
        Assert.assertEquals((Object)"Right", (Object)prop);
    }
}

