/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao;

import java.io.Serializable;
import java.util.Date;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.netmgt.dao.DatabasePopulator;
import org.opennms.netmgt.dao.api.AcknowledgmentDao;
import org.opennms.netmgt.dao.api.AlarmDao;
import org.opennms.netmgt.dao.api.DistPollerDao;
import org.opennms.netmgt.dao.api.EventDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.AckAction;
import org.opennms.netmgt.model.AckType;
import org.opennms.netmgt.model.Acknowledgeable;
import org.opennms.netmgt.model.OnmsAcknowledgment;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsEvent;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.transaction.BeforeTransaction;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath:/META-INF/opennms/applicationContext-databasePopulator.xml", "classpath:/META-INF/opennms/applicationContext-setupIpLike-enabled.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath:/META-INF/opennms/applicationContext-commonConfigs.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase(dirtiesContext=false)
public class AcknowledgmentDaoIT
implements InitializingBean {
    @Autowired
    private AcknowledgmentDao m_acknowledgmentDao;
    @Autowired
    private DistPollerDao m_distPollerDao;
    @Autowired
    private AlarmDao m_alarmDao;
    @Autowired
    private NodeDao m_nodeDao;
    @Autowired
    private EventDao m_eventDao;
    @Autowired
    private DatabasePopulator m_databasePopulator;
    private static boolean m_populated = false;

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    @BeforeTransaction
    public void setUp() {
        if (!m_populated) {
            this.m_databasePopulator.populateDatabase();
            m_populated = true;
        }
    }

    @Test
    @Transactional
    public void testSaveUnspecified() {
        OnmsAcknowledgment ack = new OnmsAcknowledgment();
        ack.setAckTime(new Date());
        ack.setAckType(AckType.UNSPECIFIED);
        ack.setAckAction(AckAction.UNSPECIFIED);
        ack.setAckUser("not-admin");
        this.getAcknowledgmentDao().save((Object)ack);
        this.getAcknowledgmentDao().flush();
        Integer id = new Integer(ack.getId());
        ack = null;
        OnmsAcknowledgment ack2 = (OnmsAcknowledgment)this.getAcknowledgmentDao().get((Serializable)id);
        Assert.assertNotNull((Object)ack2);
        Assert.assertEquals((Object)id, (Object)ack2.getId());
        Assert.assertFalse((boolean)"admin".equals(ack2.getAckUser()));
        Assert.assertEquals((Object)"not-admin", (Object)ack2.getAckUser());
    }

    private AcknowledgmentDao getAcknowledgmentDao() {
        return this.m_acknowledgmentDao;
    }

    @Test
    @Transactional
    public void testSaveWithAlarm() {
        OnmsEvent event = new OnmsEvent();
        event.setEventLog("Y");
        event.setEventDisplay("Y");
        event.setEventCreateTime(new Date());
        event.setDistPoller(this.m_distPollerDao.whoami());
        event.setEventTime(new Date());
        event.setEventSeverity(new Integer(7));
        event.setEventUei("uei://org/opennms/test/EventDaoTest");
        event.setEventSource("test");
        this.m_eventDao.save((Object)event);
        OnmsNode node = (OnmsNode)this.m_nodeDao.findAll().iterator().next();
        OnmsAlarm alarm = new OnmsAlarm();
        alarm.setNode(node);
        alarm.setUei(event.getEventUei());
        alarm.setSeverityId(event.getEventSeverity());
        alarm.setFirstEventTime(event.getEventTime());
        alarm.setLastEvent(event);
        alarm.setCounter(new Integer(1));
        alarm.setDistPoller(this.m_distPollerDao.whoami());
        alarm.setAlarmAckTime(new Date());
        alarm.setAlarmAckUser("not-admin");
        this.m_alarmDao.save((Object)alarm);
        this.m_alarmDao.flush();
        OnmsAcknowledgment ack = new OnmsAcknowledgment((Acknowledgeable)alarm);
        this.getAcknowledgmentDao().save((Object)ack);
        Integer ackId = new Integer(ack.getId());
        ack = null;
        OnmsAcknowledgment ack2 = (OnmsAcknowledgment)this.getAcknowledgmentDao().get((Serializable)ackId);
        OnmsAlarm alarm2 = (OnmsAlarm)this.m_alarmDao.get((Serializable)ack2.getRefId());
        Assert.assertEquals((Object)ack2.getAckUser(), (Object)alarm2.getAlarmAckUser());
        Assert.assertEquals((Object)ack2.getAckTime(), (Object)alarm2.getAlarmAckTime());
    }
}

