/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import java.util.Collections;
import java.util.HashSet;
import junit.framework.TestCase;
import org.opennms.netmgt.dao.support.AttributeMatchingResourceVisitor;
import org.opennms.netmgt.mock.MockResourceType;
import org.opennms.netmgt.model.AttributeVisitor;
import org.opennms.netmgt.model.OnmsAttribute;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.OnmsResourceType;
import org.opennms.netmgt.model.ResourcePath;
import org.opennms.netmgt.model.RrdGraphAttribute;
import org.opennms.test.ThrowableAnticipator;
import org.opennms.test.mock.EasyMockUtils;

public class AttributeMatchingResourceVisitorTest
extends TestCase {
    private EasyMockUtils m_mocks = new EasyMockUtils();
    private AttributeVisitor m_attributeVisitor = (AttributeVisitor)this.m_mocks.createMock(AttributeVisitor.class);

    public void testAfterPropertiesSet() throws Exception {
        AttributeMatchingResourceVisitor resourceVisitor = new AttributeMatchingResourceVisitor();
        resourceVisitor.setAttributeVisitor(this.m_attributeVisitor);
        resourceVisitor.setAttributeMatch("ifInOctets");
        resourceVisitor.afterPropertiesSet();
    }

    public void testAfterPropertiesSetNoAttributeVisitor() throws Exception {
        AttributeMatchingResourceVisitor resourceVisitor = new AttributeMatchingResourceVisitor();
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalStateException("property attributeVisitor must be set to a non-null value"));
        resourceVisitor.setAttributeVisitor(null);
        resourceVisitor.setAttributeMatch("ifInOctets");
        try {
            resourceVisitor.afterPropertiesSet();
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    public void testAfterPropertiesSetNoResourceTypeMatch() throws Exception {
        AttributeMatchingResourceVisitor resourceVisitor = new AttributeMatchingResourceVisitor();
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalStateException("property attributeMatch must be set to a non-null value"));
        resourceVisitor.setAttributeVisitor(this.m_attributeVisitor);
        resourceVisitor.setAttributeMatch(null);
        try {
            resourceVisitor.afterPropertiesSet();
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    public void testVisitWithMatch() throws Exception {
        AttributeMatchingResourceVisitor resourceVisitor = new AttributeMatchingResourceVisitor();
        resourceVisitor.setAttributeVisitor(this.m_attributeVisitor);
        resourceVisitor.setAttributeMatch("ifInOctets");
        resourceVisitor.afterPropertiesSet();
        MockResourceType resourceType = new MockResourceType();
        resourceType.setName("interfaceSnmp");
        RrdGraphAttribute attribute = new RrdGraphAttribute("ifInOctets", "something", "something else");
        OnmsResource resource = new OnmsResource("1", "Node One", (OnmsResourceType)resourceType, Collections.singleton(attribute), ResourcePath.get((String[])new String[]{"foo"}));
        this.m_attributeVisitor.visit((OnmsAttribute)attribute);
        this.m_mocks.replayAll();
        resourceVisitor.visit(resource);
        this.m_mocks.verifyAll();
    }

    public void testVisitWithoutMatch() throws Exception {
        AttributeMatchingResourceVisitor resourceVisitor = new AttributeMatchingResourceVisitor();
        resourceVisitor.setAttributeVisitor(this.m_attributeVisitor);
        resourceVisitor.setAttributeMatch("ifInOctets");
        resourceVisitor.afterPropertiesSet();
        MockResourceType resourceType = new MockResourceType();
        resourceType.setName("something other than interfaceSnmp");
        OnmsResource resource = new OnmsResource("1", "Node One", (OnmsResourceType)resourceType, new HashSet(0), ResourcePath.get((String[])new String[]{"foo"}));
        this.m_mocks.replayAll();
        resourceVisitor.visit(resource);
        this.m_mocks.verifyAll();
    }
}

