/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao;

import java.io.Serializable;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.netmgt.dao.DatabasePopulator;
import org.opennms.netmgt.dao.api.HwEntityAttributeTypeDao;
import org.opennms.netmgt.dao.api.HwEntityDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.HwEntityAttributeType;
import org.opennms.netmgt.model.OnmsHwEntity;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.transaction.AfterTransaction;
import org.springframework.test.context.transaction.BeforeTransaction;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-commonConfigs.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath:/META-INF/opennms/applicationContext-databasePopulator.xml", "classpath:/META-INF/opennms/applicationContext-setupIpLike-enabled.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase(dirtiesContext=false)
public class HwEntityDaoIT
implements InitializingBean {
    @Autowired
    NodeDao m_nodeDao;
    @Autowired
    HwEntityDao m_hwEntityDao;
    @Autowired
    HwEntityAttributeTypeDao m_hwEntityAttributeTypeDao;
    @Autowired
    DatabasePopulator m_populator;

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    @BeforeTransaction
    public void setUp() {
        this.m_populator.populateDatabase();
    }

    @AfterTransaction
    public void tearDown() {
        this.m_populator.resetDatabase();
    }

    public OnmsNode getNode() {
        return this.m_populator.getNode1();
    }

    @Test
    @Transactional
    public void testEntityCycle() {
        HwEntityAttributeType ram = new HwEntityAttributeType(".1.3.6.1.4.1.9.9.195.1.1.1.1", "ram", "integer");
        this.m_hwEntityAttributeTypeDao.save((Object)ram);
        this.m_hwEntityAttributeTypeDao.flush();
        OnmsNode node = this.getNode();
        Assert.assertNotNull((Object)node);
        Assert.assertNotNull((Object)node.getId());
        OnmsHwEntity root = new OnmsHwEntity();
        root.setEntPhysicalIndex(Integer.valueOf(1));
        root.setEntPhysicalClass("chassis");
        root.setEntPhysicalName("Chassis");
        OnmsHwEntity m1 = new OnmsHwEntity();
        m1.setEntPhysicalIndex(Integer.valueOf(2));
        m1.setEntPhysicalClass("module");
        m1.setEntPhysicalName("M1");
        m1.addAttribute(ram, "4");
        OnmsHwEntity m2 = new OnmsHwEntity();
        m2.setEntPhysicalIndex(Integer.valueOf(3));
        m2.setEntPhysicalClass("module");
        m2.setEntPhysicalName("M2");
        m2.addAttribute(ram, "2");
        root.addChildEntity(m1);
        root.addChildEntity(m2);
        Assert.assertNotNull((Object)m1.getParent());
        Assert.assertNotNull((Object)m2.getParent());
        root.setNode(node);
        Assert.assertNotNull((Object)root.getNode());
        Assert.assertEquals((long)2L, (long)root.getChildren().size());
        this.m_hwEntityDao.saveOrUpdate((Object)root);
        this.m_hwEntityDao.flush();
        OnmsHwEntity e1 = this.m_hwEntityDao.findRootByNodeId(node.getId());
        Assert.assertNotNull((Object)e1);
        Assert.assertNotNull((Object)e1.getNode());
        Assert.assertEquals((Object)e1.getNode().getId(), (Object)node.getId());
        Assert.assertEquals((long)2L, (long)e1.getChildren().size());
        Assert.assertEquals((Object)"chassis", (Object)e1.getEntPhysicalClass());
        OnmsHwEntity c = (OnmsHwEntity)e1.getChildren().iterator().next();
        Assert.assertEquals((Object)"4", (Object)c.getAttributeValue("ram"));
        Assert.assertNull((Object)this.m_hwEntityDao.findRootByNodeId(Integer.valueOf(10000)));
        OnmsHwEntity e2 = this.m_hwEntityDao.findEntityByIndex(node.getId(), e1.getEntPhysicalIndex());
        Assert.assertTrue((boolean)e1.equals((Object)e2));
        OnmsHwEntity e3 = this.m_hwEntityDao.findEntityByName(node.getId(), e1.getEntPhysicalName());
        Assert.assertTrue((boolean)e1.equals((Object)e3));
        Assert.assertEquals((Object)"Chassis", (Object)this.m_hwEntityDao.getAttributeValue(node.getId(), Integer.valueOf(1), "entPhysicalName"));
        Assert.assertEquals((Object)"4", (Object)this.m_hwEntityDao.getAttributeValue(node.getId(), Integer.valueOf(2), "ram"));
        Assert.assertEquals((Object)"chassis", (Object)this.m_hwEntityDao.getAttributeValue(node.getId(), "Chassis", "entPhysicalClass"));
        Assert.assertEquals((Object)"4", (Object)this.m_hwEntityDao.getAttributeValue(node.getId(), "~^M1", "ram"));
        this.m_hwEntityDao.flush();
        this.m_hwEntityDao.delete((Serializable)e2.getId());
        this.m_hwEntityDao.flush();
        Assert.assertNull((Object)this.m_hwEntityDao.get((Serializable)e2.getId()));
    }
}

