/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.opennms.netmgt.dao.NodeDao;
import org.opennms.netmgt.dao.hibernate.AbstractDaoHibernate;
import org.opennms.netmgt.model.OnmsCategory;
import org.opennms.netmgt.model.OnmsDistPoller;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeDaoHibernate
extends AbstractDaoHibernate<OnmsNode, Integer>
implements NodeDao {
    public NodeDaoHibernate() {
        super(OnmsNode.class);
    }

    @Override
    public OnmsNode get(String lookupCriteria) {
        if (lookupCriteria.contains(":")) {
            String[] criteria = lookupCriteria.split(":");
            return this.findByForeignId(criteria[0], criteria[1]);
        }
        return (OnmsNode)this.get(Integer.parseInt(lookupCriteria));
    }

    @Override
    public Collection<OnmsNode> findNodes(OnmsDistPoller distPoller) {
        return this.find("from OnmsNode where distPoller = ?", distPoller);
    }

    @Override
    public OnmsNode getHierarchy(Integer id) {
        OnmsNode node = (OnmsNode)this.findUnique("select distinct n from OnmsNode as n left join fetch n.assetRecord where n.id = ?", id);
        this.initialize(node.getIpInterfaces());
        for (OnmsIpInterface i : node.getIpInterfaces()) {
            this.initialize(i.getMonitoredServices());
        }
        this.initialize(node.getSnmpInterfaces());
        for (OnmsIpInterface i : node.getSnmpInterfaces()) {
            this.initialize(i.getIpInterfaces());
        }
        return node;
    }

    @Override
    public Collection<OnmsNode> findByLabel(String label) {
        return this.find("from OnmsNode as n where n.label = ?", label);
    }

    @Override
    public Collection<OnmsNode> findAllByVarCharAssetColumn(String columnName, String columnValue) {
        return this.find("from OnmsNode as n where n.assetRecord." + columnName + " = ?", columnValue);
    }

    @Override
    public Collection<OnmsNode> findAllByVarCharAssetColumnCategoryList(String columnName, String columnValue, Collection<OnmsCategory> categories) {
        return this.find("select distinct n from OnmsNode as n join n.categories as c left join fetch n.assetRecord left join fetch n.ipInterfaces as iface left join fetch iface.monitoredServices as monSvc left join fetch monSvc.serviceType left join fetch monSvc.currentOutages where n.assetRecord." + columnName + " = ? " + "and c.name in (" + this.categoryListToNameList(categories) + ")", columnValue);
    }

    @Override
    public Collection<OnmsNode> findByCategory(OnmsCategory category) {
        return this.find("select distinct n from OnmsNode as n join n.categories c left join fetch n.assetRecord left join fetch n.ipInterfaces as iface left join fetch iface.monitoredServices as monSvc left join fetch monSvc.serviceType left join fetch monSvc.currentOutages where c.name = ?", category.getName());
    }

    private String categoryListToNameList(Collection<OnmsCategory> categories) {
        ArrayList<String> categoryNames = new ArrayList<String>();
        for (OnmsCategory category : categories) {
            categoryNames.add(category.getName());
        }
        return StringUtils.collectionToDelimitedString(categoryNames, (String)", ", (String)"'", (String)"'");
    }

    @Override
    public Collection<OnmsNode> findAllByCategoryList(Collection<OnmsCategory> categories) {
        return this.find("select distinct n from OnmsNode as n join n.categories c left join fetch n.assetRecord left join fetch n.ipInterfaces as iface left join fetch iface.monitoredServices as monSvc left join fetch monSvc.serviceType left join fetch monSvc.currentOutages where c.name in (" + this.categoryListToNameList(categories) + ")" + "and n.type != 'D'");
    }

    @Override
    public Collection<OnmsNode> findAllByCategoryLists(Collection<OnmsCategory> rowCatNames, Collection<OnmsCategory> colCatNames) {
        HashSet<OnmsNode> rowNodes = new HashSet<OnmsNode>(this.findAllByCategoryList(rowCatNames));
        HashSet<OnmsNode> colNodes = new HashSet<OnmsNode>(this.findAllByCategoryList(colCatNames));
        HashSet<OnmsNode> results = new HashSet<OnmsNode>(rowNodes);
        results.retainAll(colNodes);
        return results;
    }

    @Override
    public Map<String, Integer> getForeignIdToNodeIdMap(String foreignSource) {
        List pairs = this.getHibernateTemplate().find("select n.id, n.foreignId from OnmsNode n where n.foreignSource = ?", (Object)foreignSource);
        HashMap<String, Integer> foreignIdMap = new HashMap<String, Integer>();
        for (Object[] pair : pairs) {
            foreignIdMap.put((String)pair[1], (Integer)pair[0]);
        }
        return foreignIdMap;
    }

    @Override
    public List<OnmsNode> findByForeignSource(String foreignSource) {
        return this.find("from OnmsNode n where n.foreignSource = ?", foreignSource);
    }

    @Override
    public OnmsNode findByForeignId(String foreignSource, String foreignId) {
        return (OnmsNode)this.findUnique("from OnmsNode n where n.foreignSource = ? and n.foreignId = ?", foreignSource, foreignId);
    }

    @Override
    public List<OnmsNode> findByForeignSourceAndIpAddress(String foreignSource, String ipAddress) {
        if (foreignSource == null) {
            return this.find("select distinct n from OnmsNode n join n.ipInterfaces as ip where n.foreignSource is NULL and ip.ipAddress = ?", ipAddress);
        }
        return this.find("select distinct n from OnmsNode n join n.ipInterfaces as ip where n.foreignSource = ? and ip.ipAddress = ?", foreignSource, ipAddress);
    }

    @Override
    public int getNodeCountForForeignSource(String foreignSource) {
        return this.queryInt("select count(*) from OnmsNode as n where n.foreignSource = ?", foreignSource);
    }

    @Override
    public List<OnmsNode> findAll() {
        return this.find("from OnmsNode order by label");
    }

    @Override
    public List<OnmsNode> findAllProvisionedNodes() {
        return this.find("from OnmsNode n where n.foreignSource is not null");
    }

    @Override
    public List<OnmsIpInterface> findObsoleteIpInterfaces(Integer nodeId, Date scanStamp) {
        return this.findObjects(OnmsIpInterface.class, "from OnmsIpInterface iface where iface.node.id = ? and (iface.ipLastCapsdPoll is null or iface.ipLastCapsdPoll < ?)", nodeId, scanStamp);
    }

    @Override
    public void deleteObsoleteInterfaces(Integer nodeId, Date scanStamp) {
        this.getHibernateTemplate().bulkUpdate("delete from OnmsIpInterface iface where iface.node.id = ? and (iface.ipLastCapsdPoll is null or iface.ipLastCapsdPoll < ?)", new Object[]{nodeId, scanStamp});
        this.getHibernateTemplate().bulkUpdate("delete from OnmsSnmpInterface iface where iface.node.id = ? and (iface.lastCapsdPoll is null or iface.lastCapsdPoll < ?)", new Object[]{nodeId, scanStamp});
    }

    @Override
    public void updateNodeScanStamp(Integer nodeId, Date scanStamp) {
        OnmsNode n = (OnmsNode)this.get(nodeId);
        n.setLastCapsdPoll(scanStamp);
        this.update(n);
    }

    @Override
    public Collection<Integer> getNodeIds() {
        return this.findObjects(Integer.class, "select distinct n.id from OnmsNode as n where n.type != 'D'", new Object[0]);
    }
}

