/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.commons.lang.StringUtils;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.common.Range;
import org.opennms.netmgt.config.snmp.Definition;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.netmgt.xml.event.Parms;
import org.opennms.netmgt.xml.event.Value;

public class SnmpEventInfo {
    private String m_firstIPAddress = null;
    private String m_lastIPAddress = null;
    private String m_communityString = null;
    private int m_timeout = 0;
    private int m_retryCount = 0;
    private String m_version = null;
    private int m_port = 0;
    private long m_first = 0L;
    private long m_last = 0L;

    public SnmpEventInfo() {
    }

    public SnmpEventInfo(Event event) {
        String parmName = null;
        Value parmValue = null;
        String parmContent = null;
        Parms parms = event.getParms();
        if (parms == null) {
            throw new IllegalArgumentException("SnmpEventInfo constructor: Can't construct class with event containing no parameters. " + event.toString());
        }
        if (!event.getUei().equals("uei.opennms.org/internal/configureSNMP")) {
            throw new IllegalArgumentException("Event not an a configure snmp event: " + event.toString());
        }
        for (Parm parm : parms.getParmCollection()) {
            parmName = parm.getParmName();
            parmValue = parm.getValue();
            if (parmValue == null) continue;
            parmContent = parmValue.getContent();
            try {
                if (parmName.equals("firstIPAddress")) {
                    this.setFirstIPAddress(parmContent);
                    continue;
                }
                if (parmName.equals("lastIPAddress")) {
                    this.setLastIPAddress(parmContent);
                    continue;
                }
                if (parmName.equals("communityString")) {
                    this.setCommunityString(parmContent);
                    continue;
                }
                if (parmName.equals("retryCount")) {
                    this.setRetryCount(this.computeIntValue(parmContent));
                    continue;
                }
                if (parmName.equals("timeout")) {
                    this.setTimeout(this.computeIntValue(parmContent));
                    continue;
                }
                if (parmName.equals("version")) {
                    this.setVersion(parmContent);
                    continue;
                }
                if (!parmName.equals("port")) continue;
                this.setPort(this.computeIntValue(parmContent));
            }
            catch (UnknownHostException e) {
                this.log().error("SnmpEventInfo constructor: ", (Throwable)e);
                throw new IllegalArgumentException("SnmpEventInfo constructor. " + e.getLocalizedMessage());
            }
            catch (IllegalArgumentException e) {
                this.log().error("SnmpEventInfo constructor: ", (Throwable)e);
                throw e;
            }
        }
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    public String getCommunityString() {
        return this.m_communityString;
    }

    public void setCommunityString(String communityString) {
        this.m_communityString = communityString;
    }

    public String getFirstIPAddress() {
        return this.m_firstIPAddress;
    }

    public void setFirstIPAddress(String firstIPAddress) throws UnknownHostException {
        this.m_firstIPAddress = firstIPAddress;
        this.m_first = InetAddressUtils.toIpAddrLong((InetAddress)InetAddress.getByName(firstIPAddress));
    }

    public void setFirstIPAddress(InetAddress firstIPAddress) {
        if (firstIPAddress == null) {
            this.m_firstIPAddress = null;
            this.m_first = 0L;
        } else {
            this.m_firstIPAddress = firstIPAddress.getHostAddress();
            this.m_first = InetAddressUtils.toIpAddrLong((InetAddress)firstIPAddress);
        }
    }

    public String getLastIPAddress() {
        return this.m_lastIPAddress;
    }

    public void setLastIPAddress(String lastIPAddress) throws UnknownHostException {
        if (StringUtils.isBlank((String)lastIPAddress)) {
            this.m_last = 0L;
        } else {
            this.m_lastIPAddress = lastIPAddress;
            this.m_last = InetAddressUtils.toIpAddrLong((InetAddress)InetAddress.getByName(lastIPAddress));
        }
    }

    public void setListIPAddress(InetAddress lastIPAddress) {
        if (lastIPAddress == null) {
            this.m_lastIPAddress = null;
            this.m_last = 0L;
        } else {
            this.m_lastIPAddress = lastIPAddress.getHostAddress();
            this.m_last = InetAddressUtils.toIpAddrLong((InetAddress)lastIPAddress);
        }
    }

    public long getFirst() {
        return this.m_first;
    }

    public long getLast() {
        return this.m_last;
    }

    public Range getRange() {
        if (this.isSpecific()) {
            throw new IllegalStateException("Attempted to create range with a specific." + this);
        }
        Range newRange = new Range();
        newRange.setBegin(this.getFirstIPAddress());
        newRange.setEnd(this.getLastIPAddress());
        return newRange;
    }

    public int getRetryCount() {
        return this.m_retryCount;
    }

    public void setRetryCount(int retryCount) {
        this.m_retryCount = retryCount;
    }

    public int getTimeout() {
        return this.m_timeout;
    }

    public void setTimeout(int timeout) {
        this.m_timeout = timeout;
    }

    public String getVersion() {
        return this.m_version;
    }

    public void setVersion(String version) {
        this.m_version = version;
    }

    public int getPort() {
        return this.m_port;
    }

    public void setPort(int port) {
        this.m_port = port;
    }

    public Definition createDef() {
        Definition definition = new Definition();
        if (this.getCommunityString() != null) {
            definition.setReadCommunity(this.getCommunityString());
        }
        if (this.getVersion() != null && ("v1".equals(this.getVersion()) || "v2c".equals(this.getVersion()))) {
            definition.setVersion(this.getVersion());
        }
        if (this.getRetryCount() != 0) {
            definition.setRetry(this.getRetryCount());
        }
        if (this.getTimeout() != 0) {
            definition.setTimeout(this.getTimeout());
        }
        if (this.getPort() != 0) {
            definition.setPort(this.getPort());
        }
        if (this.isSpecific()) {
            definition.addSpecific(this.getFirstIPAddress());
        } else {
            if (this.getFirst() > this.getLast()) {
                this.log().error("createDef: Can not create Definition when specified last is < first IP address: " + this);
                throw new IllegalArgumentException("First: " + this.getFirstIPAddress() + " is greater than: " + this.getLastIPAddress());
            }
            Range range = new Range();
            range.setBegin(this.getFirstIPAddress());
            range.setEnd(this.getLastIPAddress());
            definition.addRange(range);
        }
        this.log().debug("createDef: created new Definition from: " + this);
        return definition;
    }

    public boolean isSpecific() {
        return this.getLast() == 0L || this.getFirst() == this.getLast();
    }

    private int computeIntValue(String parmContent) throws IllegalArgumentException {
        int val = 0;
        try {
            val = Integer.parseInt(parmContent);
        }
        catch (NumberFormatException e) {
            this.log().error("computeIntValue: parm value passed in the event isn't a valid number.", (Throwable)e);
            throw new IllegalArgumentException(e.getLocalizedMessage());
        }
        return val;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Info: ");
        sb.append("\n\tfirst: ");
        sb.append(this.getFirstIPAddress());
        sb.append("\n\tlast: ");
        sb.append(this.getLastIPAddress());
        sb.append("\n\tversion: ");
        sb.append(this.getVersion());
        sb.append("\n\tcommunity string: ");
        sb.append(this.getCommunityString());
        sb.append("\n\tport: ");
        sb.append(String.valueOf(this.getPort()));
        sb.append("\n\tretry count: ");
        sb.append(String.valueOf(this.getRetryCount()));
        sb.append("\n\ttimeout: ");
        sb.append(this.getTimeout());
        return sb.toString();
    }
}

