/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.SpecificComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MergeableSpecific
implements Comparable<String> {
    private String m_specific;
    private SpecificComparator m_comparator;
    private long m_value;

    public MergeableSpecific(String specific) {
        ThreadCategory log = ThreadCategory.getInstance(this.getClass());
        this.m_specific = specific;
        try {
            this.m_value = InetAddressUtils.toIpAddrLong((InetAddress)InetAddress.getByName(specific));
        }
        catch (UnknownHostException e) {
            log.error("ComparableSpecific(): Exception in construction.", (Throwable)e);
            throw new IllegalArgumentException(e.getLocalizedMessage());
        }
        this.m_comparator = new SpecificComparator();
    }

    @Override
    public int compareTo(String specific) {
        return this.m_comparator.compare(this.m_specific, specific);
    }

    public String getSpecific() {
        return this.m_specific;
    }

    public void setSpecific(String specific) {
        this.m_specific = specific;
    }

    public String toString() {
        return this.m_specific;
    }

    public long getValue() {
        return this.m_value;
    }
}

