/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import java.util.ArrayList;
import java.util.List;
import org.opennms.core.utils.ReplaceAllOperation;
import org.opennms.core.utils.ReplaceFirstOperation;
import org.opennms.core.utils.StringReplaceOperation;
import org.opennms.netmgt.config.datacollection.Parameter;
import org.opennms.netmgt.dao.support.IndexStorageStrategy;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SiblingColumnStorageStrategy
extends IndexStorageStrategy {
    private static final String PARAM_SIBLING_COLUMN_OID = "sibling-column-oid";
    private String m_siblingColumnOid;
    private static final String PARAM_REPLACE_FIRST = "replace-first";
    private static final String PARAM_REPLACE_ALL = "replace-all";
    private List<StringReplaceOperation> m_replaceOps = new ArrayList<StringReplaceOperation>();

    @Override
    public String getResourceNameFromIndex(String resourceParent, String resourceIndex) {
        SnmpObjId oid = SnmpObjId.get((String)(this.m_siblingColumnOid + "." + resourceIndex));
        SnmpValue snmpValue = SnmpUtils.get((SnmpAgentConfig)this.m_storageStrategyService.getAgentConfig(), (SnmpObjId)oid);
        String value = snmpValue != null ? snmpValue.toString() : resourceIndex;
        String name = value.replaceAll("[^\\x00-\\x7F]", "").replaceAll("/", "-");
        for (StringReplaceOperation op : this.m_replaceOps) {
            this.log().debug("Doing string replacement on instance name '" + name + "' using " + op);
            name = op.replace(name);
        }
        this.log().debug("Inbound instance name was '" + resourceIndex + "', outbound was '" + ("".equals(name) ? resourceIndex : name) + "'");
        return "".equals(name) ? resourceIndex : name;
    }

    @Override
    public void setParameters(List<Parameter> parameterCollection) {
        if (parameterCollection == null) {
            this.log().fatal("Got a null parameter list, but need one containing a 'sibling-column-oid' parameter.");
            throw new RuntimeException("Got a null parameter list, but need one containing a 'sibling-column-oid' parameter.");
        }
        for (Parameter param : parameterCollection) {
            if (PARAM_SIBLING_COLUMN_OID.equals(param.getKey())) {
                this.m_siblingColumnOid = param.getValue();
                continue;
            }
            if (PARAM_REPLACE_FIRST.equals(param.getKey())) {
                this.m_replaceOps.add((StringReplaceOperation)new ReplaceFirstOperation(param.getValue()));
                continue;
            }
            if (PARAM_REPLACE_ALL.equals(param.getKey())) {
                this.m_replaceOps.add((StringReplaceOperation)new ReplaceAllOperation(param.getValue()));
                continue;
            }
            this.log().warn("Encountered unsupported parameter key=\"" + param.getKey() + "\". Can accept: " + PARAM_SIBLING_COLUMN_OID + ", " + PARAM_REPLACE_FIRST + ", " + PARAM_REPLACE_ALL);
        }
        if (this.m_siblingColumnOid == null) {
            this.log().error("The provided parameter list must contain a 'sibling-column-oid' parameter.");
            throw new RuntimeException("The provided parameter list must contain a 'sibling-column-oid' parameter.");
        }
        if (!this.m_siblingColumnOid.matches("^\\.[0-9.]+$")) {
            this.log().error("The value '" + this.m_siblingColumnOid + "' provided for parameter '" + PARAM_SIBLING_COLUMN_OID + "' is not a valid SNMP object identifier.");
            throw new RuntimeException("The value '" + this.m_siblingColumnOid + "' provided for parameter '" + PARAM_SIBLING_COLUMN_OID + "' is not a valid SNMP object identifier.");
        }
    }
}

