/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Date;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.opennms.netmgt.dao.OnmsMapDao;
import org.opennms.netmgt.dao.hibernate.AbstractDaoHibernate;
import org.opennms.netmgt.model.OnmsMap;
import org.springframework.orm.hibernate3.HibernateCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OnmsMapDaoHibernate
extends AbstractDaoHibernate<OnmsMap, Integer>
implements OnmsMapDao {
    public OnmsMapDaoHibernate() {
        super(OnmsMap.class);
    }

    @Override
    public Collection<OnmsMap> findAll(final Integer offset, final Integer limit) {
        return (Collection)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                return session.createCriteria(OnmsMap.class).setFirstResult(offset.intValue()).setMaxResults(limit.intValue()).list();
            }
        });
    }

    @Override
    public Collection<OnmsMap> findMapsLike(String mapLabel) {
        return this.find("from OnmsMap as map where map.name like ?", "%" + mapLabel + "%");
    }

    @Override
    public Collection<OnmsMap> findMapsByName(String mapLabel) {
        return this.find("from OnmsMap as map where map.name = ?", mapLabel);
    }

    @Override
    public OnmsMap findMapById(int id) {
        return (OnmsMap)this.findUnique("from OnmsMap as map where map.id = ?", id);
    }

    @Override
    public Collection<OnmsMap> findMapsByNameAndType(String mapName, String mapType) {
        Object[] values = new Object[]{mapName, mapType};
        return this.find("from OnmsMap as map where map.name = ? and map.type = ?", values);
    }

    @Override
    public Collection<OnmsMap> findMapsByType(String mapType) {
        return this.find("from OnmsMap as map where map.type = ?", mapType);
    }

    @Override
    public Collection<OnmsMap> findAutoMaps() {
        return this.findMapsByType("A");
    }

    @Override
    public Collection<OnmsMap> findUserMaps() {
        return this.findMapsByType("U");
    }

    @Override
    public Collection<OnmsMap> findSaveMaps() {
        return this.findMapsByType("S");
    }

    @Override
    public Collection<OnmsMap> findMapsByGroup(String group) {
        return this.find("from OnmsMap as map where map.mapGroup = ?", group);
    }

    @Override
    public Collection<OnmsMap> findMapsByOwner(String owner) {
        return this.find("from OnmsMap as map where map.owner = ?", owner);
    }

    @Override
    public Collection<OnmsMap> findVisibleMapsByGroup(String group) {
        Object[] values = new Object[]{"RW", "RO", "RWRO", group};
        return this.find("from OnmsMap as map where map.accessMode = ? or map.accessMode = ? or (map.accessMode = ? and map.mapGroup = ?)", values);
    }

    @Override
    public Collection<OnmsMap> findAutoAndSaveMaps() {
        Object[] values = new Object[]{"S", "A"};
        return this.find("from OnmsMap as map where map.type = ? or map.type = ? ", values);
    }

    @Override
    public int updateAllAutomatedMap(final Date time) {
        return (Integer)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<Integer>(){

            public Integer doInHibernate(Session session) throws HibernateException, SQLException {
                String hql = "update OnmsMap as map set map.lastModifiedTime = :time where map.type = :type";
                Query query = session.createQuery(hql);
                query.setTimestamp("time", time);
                query.setString("type", "A");
                return query.executeUpdate();
            }
        });
    }
}

