/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.util.List;
import org.opennms.netmgt.config.datacollection.ResourceType;
import org.opennms.netmgt.snmp.Collectable;
import org.opennms.netmgt.snmp.CollectionTracker;
import org.opennms.netmgt.snmp.ColumnTracker;
import org.opennms.netmgt.snmp.InstanceListTracker;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MibObject
implements Collectable {
    private String m_oid = null;
    private SnmpObjId m_snmpObjId = null;
    private String m_alias = null;
    private String m_type = null;
    private String m_maxval = null;
    private String m_minval = null;
    private String m_instance = null;
    private String m_groupName;
    private String m_groupIfType;
    private ResourceType m_resourceType;
    public static final String INSTANCE_IFINDEX = "ifIndex";
    public static final String INSTANCE_IFADDRESS = "ifAddress";

    public void setOid(String oid) {
        this.m_oid = oid;
        this.m_snmpObjId = null;
    }

    public void setAlias(String alias) {
        this.m_alias = alias;
    }

    public void setType(String type) {
        this.m_type = type;
    }

    public void setMaxval(String maxval) {
        this.m_maxval = maxval;
    }

    public void setMinval(String minval) {
        this.m_minval = minval;
    }

    public void setInstance(String instance) {
        this.m_instance = instance;
    }

    public void setGroupName(String groupName) {
        this.m_groupName = groupName;
    }

    public String getOid() {
        return this.m_oid;
    }

    public String getMaxval() {
        return this.m_maxval;
    }

    public String getMinval() {
        return this.m_minval;
    }

    public String getAlias() {
        return this.m_alias;
    }

    public String getType() {
        return this.m_type;
    }

    public String getInstance() {
        return this.m_instance;
    }

    public String getGroupName() {
        return this.m_groupName;
    }

    public boolean equals(Object object) {
        MibObject aMibObject;
        if (object == null) {
            return false;
        }
        try {
            aMibObject = (MibObject)object;
        }
        catch (ClassCastException cce) {
            return false;
        }
        return this.m_oid.equals(aMibObject.getOid()) && this.m_instance.equals(aMibObject.getInstance()) && (this.m_alias == null && aMibObject.getInstance() == null || this.m_alias.equals(aMibObject.getAlias())) && (this.m_type == null && aMibObject.getType() == null || this.m_type.equals(aMibObject.getType()));
    }

    public int hashCode() {
        return this.m_oid.hashCode();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("\n   group:    ").append(this.m_groupName);
        buffer.append("\n   oid:      ").append(this.m_oid);
        buffer.append("\n   instance: ").append(this.m_instance);
        buffer.append("\n   alias:    ").append(this.m_alias);
        buffer.append("\n   type:     ").append(this.m_type);
        return buffer.toString();
    }

    public CollectionTracker getCollectionTracker() {
        if (INSTANCE_IFINDEX.equals(this.getInstance()) || this.getResourceType() != null) {
            return new ColumnTracker(SnmpObjId.get((String)this.getOid()));
        }
        return new InstanceListTracker(SnmpObjId.get((String)this.getOid()), this.getInstance());
    }

    public CollectionTracker getCollectionTracker(SnmpInstId ... instances) {
        if (INSTANCE_IFINDEX.equals(this.getInstance()) || this.getResourceType() != null) {
            return new InstanceListTracker(SnmpObjId.get((String)this.getOid()), instances);
        }
        return new InstanceListTracker(SnmpObjId.get((String)this.getOid()), this.getInstance());
    }

    public static CollectionTracker[] getCollectionTrackers(List<MibObject> objList) {
        CollectionTracker[] trackers = new CollectionTracker[objList.size()];
        int index = 0;
        for (MibObject mibObj : objList) {
            trackers[index++] = mibObj.getCollectionTracker();
        }
        return trackers;
    }

    public static CollectionTracker[] getCollectionTrackers(List<MibObject> objList, SnmpInstId ... instances) {
        CollectionTracker[] trackers = new CollectionTracker[objList.size()];
        int index = 0;
        for (MibObject mibObj : objList) {
            trackers[index++] = mibObj.getCollectionTracker(instances);
        }
        return trackers;
    }

    public SnmpObjId getSnmpObjId() {
        if (this.getOid() == null) {
            return null;
        }
        if (this.m_snmpObjId == null) {
            this.m_snmpObjId = SnmpObjId.get((String)this.getOid());
        }
        return this.m_snmpObjId;
    }

    public void setGroupIfType(String groupIfType) {
        this.m_groupIfType = groupIfType;
    }

    public String getGroupIfType() {
        return this.m_groupIfType;
    }

    public void setResourceType(ResourceType resourceType) {
        this.m_resourceType = resourceType;
    }

    public ResourceType getResourceType() {
        return this.m_resourceType;
    }
}

