/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.util.ArrayList;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.common.Range;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConfigRange
implements Comparable<ConfigRange> {
    long m_begin;
    long m_end;

    public ConfigRange(long beginAddr, long endAddr) {
        if (beginAddr > endAddr) {
            throw new IllegalArgumentException("Invalid range [" + InetAddressUtils.toIpAddrString((long)beginAddr) + ", " + InetAddressUtils.toIpAddrString((long)endAddr) + "]");
        }
        this.m_begin = beginAddr;
        this.m_end = endAddr;
    }

    public ConfigRange(String beginAddr, String endAddr) {
        this(InetAddressUtils.toIpAddrLong((String)beginAddr), InetAddressUtils.toIpAddrLong((String)endAddr));
    }

    public ConfigRange(Range r) {
        this(r.getBegin(), r.getEnd());
    }

    public ConfigRange(String specific) {
        this(specific, specific);
    }

    public long getBeginLong() {
        return this.m_begin;
    }

    public long getEndLong() {
        return this.m_end;
    }

    public String getBegin() {
        return InetAddressUtils.toIpAddrString((long)this.m_begin);
    }

    public String getEnd() {
        return InetAddressUtils.toIpAddrString((long)this.m_end);
    }

    public String getSpecificString() {
        if (!this.isSpecific()) {
            throw new IllegalStateException("Cannot get the specific string unless the range as only a single addrs: " + this);
        }
        return this.getBegin();
    }

    public boolean isSpecific() {
        return this.m_begin == this.m_end;
    }

    public boolean contains(long addr) {
        return this.m_begin <= addr && addr <= this.m_end;
    }

    public boolean preceeds(ConfigRange r) {
        return this.m_end < r.m_begin;
    }

    public boolean follows(ConfigRange r) {
        return r.preceeds(this);
    }

    public boolean overlaps(ConfigRange r) {
        return this.m_begin <= r.m_end && r.m_begin <= this.m_end;
    }

    public boolean contains(ConfigRange r) {
        return this.m_begin <= r.m_begin && r.m_end <= this.m_end;
    }

    public boolean combinable(ConfigRange r) {
        return this.overlaps(r) || this.adjacent(r);
    }

    public ConfigRange combine(ConfigRange r) {
        if (!this.combinable(r)) {
            throw new IllegalArgumentException(String.format("Range %s is not combinable with range %s", this, r));
        }
        return new ConfigRange(Math.min(this.m_begin, r.m_begin), Math.max(this.m_end, r.m_end));
    }

    @Override
    public int compareTo(ConfigRange r) {
        if (this.preceeds(r)) {
            return -1;
        }
        if (this.follows(r)) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ConfigRange) {
            ConfigRange r = (ConfigRange)obj;
            return this.m_begin == r.m_begin && this.m_end == r.m_end;
        }
        return false;
    }

    public int hashCode() {
        return Long.valueOf(this.m_begin).hashCode() * 31 + Long.valueOf(this.m_end).hashCode();
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("[");
        b.append(InetAddressUtils.toIpAddrString((long)this.m_begin));
        b.append(",");
        b.append(InetAddressUtils.toIpAddrString((long)this.m_end));
        b.append("]");
        return b.toString();
    }

    public boolean contains(String address) {
        return this.contains(InetAddressUtils.toIpAddrLong((String)address));
    }

    public boolean adjacent(ConfigRange r) {
        return r.m_end + 1L == this.m_begin || this.m_end + 1L == r.m_begin;
    }

    public ConfigRange[] remove(ConfigRange r) {
        if (r.contains(this)) {
            return new ConfigRange[0];
        }
        if (!this.overlaps(r)) {
            return new ConfigRange[]{this};
        }
        ArrayList<ConfigRange> ranges = new ArrayList<ConfigRange>(2);
        if (this.m_begin < r.m_begin) {
            ranges.add(new ConfigRange(this.m_begin, r.m_begin - 1L));
        }
        if (r.m_end < this.m_end) {
            ranges.add(new ConfigRange(r.m_end + 1L, this.m_end));
        }
        return ranges.toArray(new ConfigRange[ranges.size()]);
    }
}

