/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.dao.AcknowledgmentDao;
import org.opennms.netmgt.model.Acknowledgeable;
import org.opennms.netmgt.model.OnmsAcknowledgment;
import org.opennms.netmgt.model.acknowledgments.AckService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultAckService
implements AckService {
    private AcknowledgmentDao m_ackDao;

    public void processAcks(Collection<OnmsAcknowledgment> acks) {
        this.log().info((Object)("processAcks: Processing " + acks.size() + " acknowledgements..."));
        for (OnmsAcknowledgment ack : acks) {
            this.processAck(ack);
        }
    }

    public void processAck(OnmsAcknowledgment ack) {
        this.log().info((Object)("processAck: Searching DB for acknowledgables for ack: " + ack));
        List<Acknowledgeable> ackables = this.m_ackDao.findAcknowledgables(ack);
        if (ackables == null || ackables.size() < 1) {
            this.log().debug((Object)"processAck: No acknowledgables found.");
            throw new IllegalStateException("No acknowlegables in the database for ack: " + ack);
        }
        this.log().debug((Object)("processAck: Found " + ackables.size() + ". Acknowledging..."));
        Iterator<Acknowledgeable> it = ackables.iterator();
        while (it.hasNext()) {
            try {
                Acknowledgeable ackable = it.next();
                switch (ack.getAckAction()) {
                    case ACKNOWLEDGE: {
                        this.log().debug((Object)("processAck: Acknowledging ackable: " + ackable + "..."));
                        ackable.acknowledge(ack.getAckUser());
                        this.log().debug((Object)("processAck: Acknowledged ackable: " + ackable));
                        break;
                    }
                    case UNACKNOWLEDGE: {
                        this.log().debug((Object)("processAck: Unacknowledging ackable: " + ackable + "..."));
                        ackable.unacknowledge(ack.getAckUser());
                        this.log().debug((Object)("processAck: Unacknowledged ackable: " + ackable));
                        break;
                    }
                    case CLEAR: {
                        this.log().debug((Object)("processAck: Clearing ackable: " + ackable + "..."));
                        ackable.clear(ack.getAckUser());
                        this.log().debug((Object)("processAck: Cleared ackable: " + ackable));
                        break;
                    }
                    case ESCALATE: {
                        this.log().debug((Object)("processAck: Escalating ackable: " + ackable + "..."));
                        ackable.escalate(ack.getAckUser());
                        this.log().debug((Object)("processAck: Escalated ackable: " + ackable));
                        break;
                    }
                }
                this.m_ackDao.updateAckable(ackable);
                this.m_ackDao.save(ack);
                this.m_ackDao.flush();
            }
            catch (Throwable t) {
                this.log().error((Object)("processAck: exception while processing: " + ack + "; " + t), t);
            }
        }
        this.log().info((Object)("processAck: Found and processed acknowledgables for the acknowledgement: " + ack));
    }

    private Logger log() {
        return ThreadCategory.getInstance();
    }

    public void setAckDao(AcknowledgmentDao ackDao) {
        this.m_ackDao = ackDao;
    }

    public AcknowledgmentDao getAckDao() {
        return this.m_ackDao;
    }
}

