/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import java.sql.SQLException;
import java.util.Collection;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.opennms.netmgt.dao.OnmsMapElementDao;
import org.opennms.netmgt.dao.hibernate.AbstractDaoHibernate;
import org.opennms.netmgt.model.OnmsMap;
import org.opennms.netmgt.model.OnmsMapElement;
import org.springframework.orm.hibernate3.HibernateCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OnmsMapElementDaoHibernate
extends AbstractDaoHibernate<OnmsMapElement, Integer>
implements OnmsMapElementDao {
    public OnmsMapElementDaoHibernate() {
        super(OnmsMapElement.class);
    }

    @Override
    public Collection<OnmsMapElement> findAll(final Integer offset, final Integer limit) {
        return (Collection)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                return session.createCriteria(OnmsMap.class).setFirstResult(offset.intValue()).setMaxResults(limit.intValue()).list();
            }
        });
    }

    @Override
    public OnmsMapElement findMapElementById(int id) {
        return (OnmsMapElement)this.findUnique("from OnmsMapElement as element where element.id = ?", id);
    }

    @Override
    public Collection<OnmsMapElement> findMapElementsByMapId(OnmsMap map) {
        return this.find("from OnmsMapElement as element where element.map = ?", map);
    }

    @Override
    public void deleteElementsByMapId(OnmsMap map) {
        for (OnmsMapElement elem : this.find("from OnmsMapElement as element where element.map = ?", map)) {
            this.delete(elem);
        }
    }

    @Override
    public void deleteElementsByType(String type) {
        for (OnmsMapElement elem : this.find("from OnmsMapElement as element where element.type = ?", type)) {
            this.delete(elem);
        }
    }

    @Override
    public void deleteElementsByElementIdAndType(int id, String type) {
        Object[] values = new Object[]{id, type};
        for (OnmsMapElement elem : this.find("from OnmsMapElement as element where element.elementId = ? and element.type = ?", values)) {
            this.delete(elem);
        }
    }

    @Override
    public Collection<OnmsMapElement> findElementsByElementIdAndType(int elementId, String type) {
        Object[] values = new Object[]{elementId, type};
        return this.find("from OnmsMapElement as element where element.elementId = ? and element.type = ?", values);
    }

    @Override
    public Collection<OnmsMapElement> findElementsByType(String type) {
        return this.find("from OnmsMapElement as element where element.type = ?", type);
    }

    @Override
    public OnmsMapElement findMapElement(int elementId, String type, OnmsMap map) {
        Object[] values = new Object[]{elementId, type, map};
        return (OnmsMapElement)this.findUnique("from OnmsMapElement as element where element.elementId = ? and element.type = ? and element.map = ?", values);
    }
}

