/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.ValidationException;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.opennms.netmgt.config.monitoringLocations.LocationDef;
import org.opennms.netmgt.config.monitoringLocations.MonitoringLocationsConfiguration;
import org.opennms.netmgt.dao.CastorDataAccessFailureException;
import org.opennms.netmgt.dao.LocationMonitorDao;
import org.opennms.netmgt.dao.castor.CastorUtils;
import org.opennms.netmgt.dao.hibernate.AbstractDaoHibernate;
import org.opennms.netmgt.model.LocationMonitorIpInterface;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsLocationMonitor;
import org.opennms.netmgt.model.OnmsLocationSpecificStatus;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsMonitoringLocationDefinition;
import org.springframework.core.io.Resource;
import org.springframework.orm.hibernate3.HibernateCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocationMonitorDaoHibernate
extends AbstractDaoHibernate<OnmsLocationMonitor, Integer>
implements LocationMonitorDao {
    private MonitoringLocationsConfiguration m_monitoringLocationsConfiguration;
    private Resource m_monitoringLocationConfigResource;

    public LocationMonitorDaoHibernate() {
        super(OnmsLocationMonitor.class);
        if (this.m_monitoringLocationConfigResource != null) {
            this.initializeConfigurations();
        }
    }

    @Override
    public List<OnmsMonitoringLocationDefinition> findAllMonitoringLocationDefinitions() {
        this.assertPropertiesSet();
        List<OnmsMonitoringLocationDefinition> onmsDefs = new ArrayList<OnmsMonitoringLocationDefinition>();
        List locationDefCollection = this.m_monitoringLocationsConfiguration.getLocations().getLocationDefCollection();
        if (locationDefCollection != null) {
            onmsDefs = this.convertDefs(locationDefCollection);
        }
        return onmsDefs;
    }

    private List<OnmsMonitoringLocationDefinition> convertDefs(List<LocationDef> defs) {
        LinkedList<OnmsMonitoringLocationDefinition> onmsDefs = new LinkedList<OnmsMonitoringLocationDefinition>();
        for (LocationDef def : defs) {
            OnmsMonitoringLocationDefinition onmsDef = new OnmsMonitoringLocationDefinition();
            onmsDef.setArea(def.getMonitoringArea());
            onmsDef.setName(def.getLocationName());
            onmsDef.setPollingPackageName(def.getPollingPackageName());
            onmsDefs.add(onmsDef);
        }
        return onmsDefs;
    }

    @Override
    public void saveMonitoringLocationDefinitions(Collection<OnmsMonitoringLocationDefinition> onmsDefs) {
        List defs = this.m_monitoringLocationsConfiguration.getLocations().getLocationDefCollection();
        for (OnmsMonitoringLocationDefinition onmsDef : onmsDefs) {
            for (LocationDef def : defs) {
                if (!def.getLocationName().equals(onmsDef.getName())) continue;
                def.setMonitoringArea(onmsDef.getArea());
                def.setPollingPackageName(onmsDef.getArea());
            }
        }
        this.saveMonitoringConfig();
    }

    @Override
    public void saveMonitoringLocationDefinition(OnmsMonitoringLocationDefinition onmsDef) {
        List defs = this.m_monitoringLocationsConfiguration.getLocations().getLocationDefCollection();
        for (LocationDef def : defs) {
            if (!onmsDef.getName().equals(def.getLocationName())) continue;
            def.setMonitoringArea(onmsDef.getArea());
            def.setPollingPackageName(onmsDef.getPollingPackageName());
        }
        this.saveMonitoringConfig();
    }

    protected void saveMonitoringConfig() {
        String xml = null;
        StringWriter writer = new StringWriter();
        try {
            Marshaller.marshal((Object)this.m_monitoringLocationsConfiguration, (Writer)writer);
            xml = writer.toString();
            this.saveXml(xml);
        }
        catch (MarshalException e) {
            throw new CastorDataAccessFailureException("saveMonitoringConfig: couldn't marshal confg: \n" + (xml != null ? xml : ""), e);
        }
        catch (ValidationException e) {
            throw new CastorDataAccessFailureException("saveMonitoringConfig: couldn't validate confg: \n" + (xml != null ? xml : ""), e);
        }
        catch (IOException e) {
            throw new CastorDataAccessFailureException("saveMonitoringConfig: couldn't write confg: \n" + (xml != null ? xml : ""), e);
        }
    }

    protected void saveXml(String xml) throws IOException {
        if (xml != null) {
            FileWriter fileWriter = new FileWriter(this.m_monitoringLocationConfigResource.getFile());
            fileWriter.write(xml);
            fileWriter.flush();
            fileWriter.close();
        }
    }

    private LocationDef getLocationDef(String definitionName) {
        List defs = this.m_monitoringLocationsConfiguration.getLocations().getLocationDefCollection();
        LocationDef matchingDef = null;
        for (LocationDef def : defs) {
            if (!def.getLocationName().equals(definitionName)) continue;
            matchingDef = def;
        }
        return matchingDef;
    }

    private void initializeConfigurations() {
        this.initializeMonitoringLocationDefinition();
    }

    private void initializeMonitoringLocationDefinition() {
        this.m_monitoringLocationsConfiguration = CastorUtils.unmarshalWithTranslatedExceptions(MonitoringLocationsConfiguration.class, this.m_monitoringLocationConfigResource);
    }

    public Collection<OnmsMonitoringLocationDefinition> findAllLocationDefinitions() {
        this.assertPropertiesSet();
        LinkedList<OnmsMonitoringLocationDefinition> eDefs = new LinkedList<OnmsMonitoringLocationDefinition>();
        List defs = this.m_monitoringLocationsConfiguration.getLocations().getLocationDefCollection();
        for (LocationDef def : defs) {
            eDefs.add(this.createEntityDef(def));
        }
        return eDefs;
    }

    private void assertPropertiesSet() {
        if (this.m_monitoringLocationConfigResource == null && this.m_monitoringLocationsConfiguration == null) {
            throw new IllegalStateException("either monitoringLocationConfigResource or monitorLocationsConfiguration must be set but is not");
        }
    }

    private OnmsMonitoringLocationDefinition createEntityDef(LocationDef def) {
        OnmsMonitoringLocationDefinition eDef = new OnmsMonitoringLocationDefinition();
        eDef.setArea(def.getMonitoringArea());
        eDef.setName(def.getLocationName());
        eDef.setPollingPackageName(def.getPollingPackageName());
        return eDef;
    }

    public MonitoringLocationsConfiguration getMonitoringLocationsConfiguration() {
        return this.m_monitoringLocationsConfiguration;
    }

    public void setMonitoringLocationsConfiguration(MonitoringLocationsConfiguration monitoringLocationsConfiguration) {
        this.m_monitoringLocationsConfiguration = monitoringLocationsConfiguration;
    }

    public Resource getMonitoringLocationConfigResource() {
        return this.m_monitoringLocationConfigResource;
    }

    public void setMonitoringLocationConfigResource(Resource monitoringLocationResource) {
        this.m_monitoringLocationConfigResource = monitoringLocationResource;
        this.initializeMonitoringLocationDefinition();
    }

    @Override
    public OnmsMonitoringLocationDefinition findMonitoringLocationDefinition(String monitoringLocationDefinitionName) {
        if (monitoringLocationDefinitionName == null) {
            throw new IllegalArgumentException("monitoringLocationDefinitionName must not be null");
        }
        this.assertPropertiesSet();
        LocationDef locationDef = this.getLocationDef(monitoringLocationDefinitionName);
        if (locationDef == null) {
            return null;
        }
        return this.createEntityDef(locationDef);
    }

    @Override
    public OnmsLocationSpecificStatus getMostRecentStatusChange(final OnmsLocationMonitor locationMonitor, final OnmsMonitoredService monSvc) {
        HibernateCallback callback = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                return session.createQuery("from OnmsLocationSpecificStatus status where status.locationMonitor = :locationMonitor and status.monitoredService = :monitoredService order by status.pollResult.timestamp desc").setEntity("locationMonitor", (Object)locationMonitor).setEntity("monitoredService", (Object)monSvc).setMaxResults(1).uniqueResult();
            }
        };
        return (OnmsLocationSpecificStatus)this.getHibernateTemplate().execute(callback);
    }

    @Override
    public void saveStatusChange(OnmsLocationSpecificStatus statusChange) {
        this.getHibernateTemplate().save((Object)statusChange);
    }

    @Override
    public Collection<OnmsLocationMonitor> findByLocationDefinition(OnmsMonitoringLocationDefinition locationDefinition) {
        return this.find("from OnmsLocationMonitor as mon where mon.definitionName = ?", locationDefinition.getName());
    }

    @Override
    public Collection<OnmsLocationSpecificStatus> getAllMostRecentStatusChanges() {
        return this.getAllStatusChangesAt(new Date());
    }

    @Override
    public Collection<OnmsLocationSpecificStatus> getAllStatusChangesAt(Date timestamp) {
        return this.findObjects(OnmsLocationSpecificStatus.class, "from OnmsLocationSpecificStatus as status where status.pollResult.timestamp = (     select max(recentStatus.pollResult.timestamp)     from OnmsLocationSpecificStatus as recentStatus     where recentStatus.pollResult.timestamp < ?     group by recentStatus.locationMonitor, recentStatus.monitoredService     having recentStatus.locationMonitor = status.locationMonitor     and recentStatus.monitoredService = status.monitoredService )", timestamp);
    }

    @Override
    public Collection<OnmsLocationSpecificStatus> getStatusChangesBetween(Date startDate, Date endDate) {
        return this.findObjects(OnmsLocationSpecificStatus.class, "from OnmsLocationSpecificStatus as status where ? <= status.pollResult.timestamp and status.pollResult.timestamp < ?", startDate, endDate);
    }

    @Override
    public Collection<LocationMonitorIpInterface> findStatusChangesForNodeForUniqueMonitorAndInterface(int nodeId) {
        List l = this.getHibernateTemplate().find("select distinct status.locationMonitor, status.monitoredService.ipInterface from OnmsLocationSpecificStatus as status where status.monitoredService.ipInterface.node.id = ?", (Object)nodeId);
        HashSet<LocationMonitorIpInterface> ret = new HashSet<LocationMonitorIpInterface>();
        for (Object o : l) {
            OnmsLocationMonitor mon = (OnmsLocationMonitor)((Object[])o)[0];
            OnmsIpInterface ip = (OnmsIpInterface)((Object[])o)[1];
            ret.add(new LocationMonitorIpInterface(mon, ip));
        }
        return ret;
    }
}

