/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.castor.collector;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.log4j.Category;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.collectd.CollectdConfiguration;
import org.opennms.netmgt.config.collectd.Collector;
import org.opennms.netmgt.dao.castor.CastorUtils;
import org.opennms.netmgt.dao.castor.collector.CollectdConfigVisitor;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class CollectdConfigFile {
    File m_file;

    public CollectdConfigFile(File file) {
        this.m_file = file;
    }

    public void visit(CollectdConfigVisitor visitor) {
        CollectdConfiguration collectdConfiguration = this.getCollectdConfiguration();
        visitor.visitCollectdConfiguration(collectdConfiguration);
        for (Collector collector : collectdConfiguration.getCollectorCollection()) {
            this.doVisit(collector, visitor);
        }
        visitor.completeCollectdConfiguration(collectdConfiguration);
    }

    private void doVisit(Collector collector, CollectdConfigVisitor visitor) {
        visitor.visitCollectorCollection(collector);
        visitor.completeCollectorCollection(collector);
    }

    private CollectdConfiguration getCollectdConfiguration() {
        try {
            return CastorUtils.unmarshal(CollectdConfiguration.class, (Resource)new FileSystemResource(this.m_file));
        }
        catch (MarshalException e) {
            throw this.runtimeException("Syntax error in " + this.m_file, (Exception)((Object)e));
        }
        catch (ValidationException e) {
            throw this.runtimeException("invalid attribute in " + this.m_file, (Exception)((Object)e));
        }
        catch (FileNotFoundException e) {
            throw this.runtimeException("Unable to find file " + this.m_file, e);
        }
        catch (IOException e) {
            throw this.runtimeException("Unable to find access " + this.m_file, e);
        }
    }

    private RuntimeException runtimeException(String msg, Exception e) {
        this.log().error((Object)msg, (Throwable)e);
        return new RuntimeException(msg, e);
    }

    private Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }
}

