/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.castor;

import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opennms.netmgt.config.ackd.AckdConfiguration;
import org.opennms.netmgt.config.ackd.Parameter;
import org.opennms.netmgt.config.ackd.Reader;
import org.opennms.netmgt.config.ackd.ReaderSchedule;
import org.opennms.netmgt.dao.AckdConfigurationDao;
import org.opennms.netmgt.dao.castor.AbstractCastorConfigDao;
import org.springframework.dao.DataAccessResourceFailureException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultAckdConfigurationDao
extends AbstractCastorConfigDao<AckdConfiguration, AckdConfiguration>
implements AckdConfigurationDao {
    public DefaultAckdConfigurationDao() {
        super(AckdConfiguration.class, "Ackd Configuration");
    }

    @Override
    public AckdConfiguration getConfig() {
        return (AckdConfiguration)this.getContainer().getObject();
    }

    @Override
    public AckdConfiguration translateConfig(AckdConfiguration castorConfig) {
        return castorConfig;
    }

    @Override
    public Boolean acknowledgmentMatch(List<String> messageText) {
        String expression = this.getConfig().getAckExpression();
        return this.matcher(messageText, expression);
    }

    @Override
    public Boolean clearMatch(List<String> messageText) {
        String expression = this.getConfig().getClearExpression();
        return this.matcher(messageText, expression);
    }

    @Override
    public Boolean escalationMatch(List<String> messageText) {
        String expression = this.getConfig().getEscalateExpression();
        return this.matcher(messageText, expression);
    }

    @Override
    public Boolean unAcknowledgmentMatch(List<String> messageText) {
        String expression = this.getConfig().getUnackExpression();
        return this.matcher(messageText, expression);
    }

    private Boolean matcher(List<String> messageText, String expression) {
        Boolean matches = new Boolean(false);
        if (expression.startsWith("~")) {
            String text;
            Matcher m;
            expression = expression.startsWith("~") ? expression.substring(1) : expression;
            Pattern p = Pattern.compile(expression);
            Iterator<String> i$ = messageText.iterator();
            while (i$.hasNext() && !(matches = Boolean.valueOf((m = p.matcher(text = i$.next())).matches())).booleanValue()) {
            }
        } else {
            for (String text : messageText) {
                matches = expression.equalsIgnoreCase(text);
            }
        }
        return matches;
    }

    @Override
    public Reader getReader(String readerName) {
        Reader readerByName = null;
        List readers = this.getConfig().getReaders().getReaderCollection();
        for (Reader reader : readers) {
            if (!readerName.equals(reader.getReaderName())) continue;
            readerByName = reader;
        }
        return readerByName;
    }

    @Override
    public ReaderSchedule getReaderSchedule(String readerName) {
        ReaderSchedule schedule = null;
        Reader reader = this.getReader(readerName);
        if (reader != null) {
            schedule = reader.getReaderSchedule();
        }
        return schedule;
    }

    @Override
    public boolean isReaderEnabled(String readerName) {
        boolean enabled = false;
        Reader reader = this.getReader(readerName);
        if (reader != null) {
            enabled = reader.isEnabled();
        }
        return enabled;
    }

    @Override
    public void reloadConfiguration() throws DataAccessResourceFailureException {
        this.getContainer().reload();
    }

    @Override
    public int getEnabledReaderCount() {
        int cnt = 0;
        for (Reader reader : this.getConfig().getReaders().getReaderCollection()) {
            if (!reader.isEnabled()) continue;
            ++cnt;
        }
        return cnt;
    }

    @Override
    public List<Parameter> getParametersForReader(String name) {
        return this.getReader(name).getParameterCollection();
    }
}

